package org.tekkotsu.sketch;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import java.util.Hashtable;
import java.awt.image.IndexColorModel;
import java.awt.Graphics;

// stores info for a Sketch, to use as UserObject for DefaultMutableTreeNode
public class SketchInfo extends VisualObjectInfo {
    static Icon icon = new ImageIcon("org/tekkotsu/mon/icons/sketch.png");
    static Icon inverted_icon = new ImageIcon("org/tekkotsu/mon/icons/sketchinv.png");;

    static Icon int_icon = new ImageIcon("org/tekkotsu/mon/icons/sketchint.png");
    static Icon inverted_int_icon = new ImageIcon("org/tekkotsu/mon/icons/sketchintinv.png");


    public static final int SKETCH_INT_TYPE   = 1;
    public static final int SKETCH_BOOL_TYPE  = 2;
    public static final int SKETCH_FLOAT_TYPE = 3;
    

    boolean imageLoaded;
    BufferedImage img;
    boolean isSketchBool;
    int grayColor;

    public SketchInfo(int _id, int _parentId, String _name, 
		      Color _color, int sketchType) {
	super(_id, _parentId, _name, _color);
	imageLoaded = false;
	img = null;
	isSketchBool = true;
	if (sketchType == SKETCH_INT_TYPE)
	    {
		isSketchBool = false;
	    }
	else if (sketchType == SKETCH_FLOAT_TYPE)
	    {
		System.out.println("Warning, got a SketchFloat, treating it like a SketchInt");
		isSketchBool = false;
	    }
    }
    
    public Icon getIcon() { 
	if (inverted)
	    {
		if (isSketchBool)
		    return inverted_icon;
		else
		    return inverted_int_icon;
	    }
	else
	    {
		if (isSketchBool)
		    return icon;
		else
		    return int_icon;
	    }
	}

    public boolean isImageLoaded() { return imageLoaded; }

    public BufferedImage getImage() { return img; }

    public void unloadImage()
    {
	imageLoaded = false;
	img = null;
    }


    // Deep image copying
    public void copyImage(BufferedImage _img)
    {
	Hashtable colortable = new Hashtable();
	int colorCount = 0;
	boolean lookingForGray = true;

	if (_img == null)
	    return;
	System.out.println("Type = "+_img.getType()+" RGB="+BufferedImage.TYPE_INT_ARGB);
	img = new BufferedImage(_img.getWidth(), _img.getHeight(), _img.getType(),((IndexColorModel) _img.getColorModel()));
	img.getRaster().setRect(_img.getRaster());

	for (int i=0; i<_img.getWidth()*_img.getHeight(); i++)
	    {
		int x = i % _img.getWidth();
		int y = i / _img.getWidth();

		// Count the colors
		if (!colortable.containsKey(new Integer(_img.getRGB(x,y))))
		{
		    System.out.println("Color found: "+new Color(_img.getRGB(x,y)));
		    colortable.put(new Integer(_img.getRGB(x,y)),new Integer(_img.getRGB(x,y)));
		    if (++colorCount > 2)
			{
			    isSketchBool = false;
			    break;
			}
		}
		
		if (lookingForGray && _img.getRGB(x,y) == Color.GRAY.getRGB())
		    {
			grayColor = img.getRGB(x,y);
			lookingForGray = false; 
		    }
	    
		/*if (!newttable.containsKey(new Integer(img.getRGB(x,y))))
		{
		    System.out.println("New Color found: "+new Color(img.getRGB(x,y)));
		    newttable.put(new Integer(img.getRGB(x,y)),new Integer(img.getRGB(x,y)));
		    }*/
	    }
	imageLoaded = true;
    }

    public boolean isSketchBool() { return isSketchBool; }

    public void renderTo(Graphics2D g)
    {
	if (inverted)
	    System.out.print("Inverted ");
	System.out.println("Sketch rendering");
	if (img != null)
	    {
		g.setColor(getColor());
		for (int x = 0; x<img.getWidth(); x++)
		    {
			for (int y=0; y< img.getHeight(); y++)
			    {
				int cur = img.getRGB(x,y);
				if (cur != grayColor)
				    {
					if (isSketchBool)
					    g.drawLine(x,y,x,y);
					else
					{
					    g.setColor(new Color(cur));
					    g.drawLine(x,y,x,y);
					}
				    }
			    }
		    }
	    }
    }


    public void renderToArrays(int r[], int g[], int b[], int counts[])
    {
	int curR = getColor().getRed();
	int curG = getColor().getGreen();
	int curB = getColor().getBlue();
	if (img!= null)
	    {
		for (int y=0; y< img.getHeight(); y++)
		    {
			for (int x = 0; x<img.getWidth(); x++)
			    {
				int pos = y*img.getWidth()+x;
				int cur = img.getRGB(x,y);
				if (cur != grayColor)
				    {
					if (!isSketchBool)
					    {
						Color c = new Color(cur);
						curR = c.getRed();
						curG = c.getGreen();
						curB = c.getBlue();
						if (inverted)
						    {
							curR = 255 - curR;
							curG = 255 - curG;
							curB = 255 - curB;
						    }
					    }
					
					r[pos] += curR;
					g[pos] += curG;
					b[pos] += curB;
					counts[pos]++;
				    }
			    }
		    }
	    }
   }

}




