package org.tekkotsu.mon;

import java.io.InputStream;
import java.net.Socket;

public class WorldStateJointsListener extends TCPListener {
  boolean _updatedFlag=false;
  Joints _data;
  Joints _outd;

  public void connected(Socket socket) {
    _isConnected=true;
    _data=new Joints();
    _outd=new Joints();
    try {
      InputStream in=socket.getInputStream();
      fireConnected();
      while (true) {
        _data.timestamp=readInt(in);
				//System.out.println("time="+_data.timestamp);
				int NumPIDJoints=readInt(in);
				_data.positions=new float[NumPIDJoints];
				_data.duties=new float[NumPIDJoints];
				//System.out.println("pid="+NumPIDJoints);
        for (int i=0; i<NumPIDJoints; i++)
          _data.positions[i]=readFloat(in);
				int NumSensors=readInt(in);
				_data.sensors=new float[NumSensors];
				//System.out.println("sensor="+NumSensors);
        for (int i=0; i<NumSensors; i++)
          _data.sensors[i]=readFloat(in);
				int NumButtons=readInt(in);
				_data.buttons=new float[NumButtons];
				//System.out.println("button="+NumButtons);
        for (int i=0; i<NumButtons; i++)
          _data.buttons[i]=readFloat(in);
        for (int i=0; i<NumPIDJoints; i++)
          _data.duties[i]=readFloat(in);

        synchronized(_outd) {
          Joints temp=_data;
          _data=_outd;
          _outd=temp;
          _updatedFlag=true;
        }
      }
    } catch (Exception ex) {
    } finally {
      fireDisconnected();
    }

    try { socket.close(); } catch (Exception ex) { }
    _isConnected=false;
  }
 
  public boolean hasData() {
    return _updatedFlag;
  }

  public Joints getData() {
    synchronized (_outd) {
      _updatedFlag=false;
      return _outd;
    }
  }

  public boolean isConnected() {
    return _isConnected;
  }

  public WorldStateJointsListener() { super(); needConnection(); }
  public WorldStateJointsListener(int port) { super(port); needConnection(); }
  public WorldStateJointsListener(String host, int port) { super(host,port); needConnection(); }
}
