/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPControlSocket {
    private static String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.6 2003/05/31 14:53:44 bruceb Exp $";
    static final String EOL = "\r\n";
    static final int CONTROL_PORT = 21;
    private static final String DEBUG_ARROW = "---> ";
    private static final String PASSWORD_MESSAGE = "---> PASS";
    private boolean debugResponses = false;
    private PrintWriter log = new PrintWriter(System.out);
    private Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader reader = null;

    public FTPControlSocket(String remoteHost, int controlPort, PrintWriter log, int timeout) throws IOException, FTPException {
        this.setLogStream(log);
        this.controlSock = new Socket(remoteHost, controlPort);
        this.setTimeout(timeout);
        this.initStreams();
        this.validateConnection();
        this.debugResponses(false);
    }

    public FTPControlSocket(InetAddress remoteAddr, int controlPort, PrintWriter log, int timeout) throws IOException, FTPException {
        this.setLogStream(log);
        this.controlSock = new Socket(remoteAddr, controlPort);
        this.setTimeout(timeout);
        this.initStreams();
        this.validateConnection();
        this.debugResponses(false);
    }

    private void validateConnection() throws IOException, FTPException {
        String reply = this.readReply();
        this.validateReply(reply, "220");
    }

    private void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os);
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    void setTimeout(int millis) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(millis);
    }

    public void logout() throws IOException {
        if (this.log != null) {
            this.log.flush();
            this.log = null;
        }
        IOException ex = null;
        try {
            this.writer.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    FTPDataSocket createDataSocket(FTPConnectMode connectMode) throws IOException, FTPException {
        if (connectMode == FTPConnectMode.ACTIVE) {
            return new FTPDataSocket(this.createDataSocketActive());
        }
        return new FTPDataSocket(this.createDataSocketPASV());
    }

    ServerSocket createDataSocketActive() throws IOException, FTPException {
        ServerSocket socket = new ServerSocket(0);
        InetAddress localhost = this.controlSock.getLocalAddress();
        this.setDataPort(localhost, (short)socket.getLocalPort());
        return socket;
    }

    private short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    protected byte[] toByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    private void setDataPort(InetAddress host, short portNo) throws IOException, FTPException {
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = this.toByteArray(portNo);
        String cmd = "PORT " + this.toUnsignedShort(hostBytes[0]) + "," + this.toUnsignedShort(hostBytes[1]) + "," + this.toUnsignedShort(hostBytes[2]) + "," + this.toUnsignedShort(hostBytes[3]) + "," + this.toUnsignedShort(portBytes[0]) + "," + this.toUnsignedShort(portBytes[1]);
        String reply = this.sendCommand(cmd);
        this.validateReply(reply, "200");
    }

    Socket createDataSocketPASV() throws IOException, FTPException {
        String reply = this.sendCommand("PASV");
        this.validateReply(reply, "227");
        int startIP = reply.indexOf(40);
        int endIP = reply.indexOf(41);
        if (startIP < 0 && endIP < 0) {
            startIP = reply.toUpperCase().lastIndexOf("MODE") + 4;
            endIP = reply.length();
        }
        String ipData = reply.substring(startIP + 1, endIP);
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len && partCount <= 6) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch == ',' || i + 1 == len) {
                try {
                    parts[partCount++] = Integer.parseInt(buf.toString());
                    buf.setLength(0);
                }
                catch (NumberFormatException ex) {
                    throw new FTPException("Malformed PASV reply: " + reply);
                }
            }
            ++i;
        }
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        return new Socket(ipAddress, port);
    }

    String sendCommand(String command) throws IOException {
        this.log(DEBUG_ARROW + command);
        this.writer.write(command + EOL);
        this.writer.flush();
        return this.readReply();
    }

    String readReply() throws IOException {
        String firstLine = this.reader.readLine();
        if (firstLine == null || firstLine.length() == 0) {
            throw new IOException("Unexpected null reply received");
        }
        StringBuffer reply = new StringBuffer(firstLine);
        this.log(reply.toString());
        String replyCode = reply.toString().substring(0, 3);
        if (reply.charAt(3) == '-') {
            boolean complete = false;
            while (!complete) {
                String line = this.reader.readLine();
                if (line == null) {
                    throw new IOException("Unexpected null reply received");
                }
                this.log(line);
                if (line.length() > 3 && line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ");
                reply.append(line);
            }
        }
        return reply.toString();
    }

    FTPReply validateReply(String reply, String expectedReplyCode) throws IOException, FTPException {
        String replyCode = reply.substring(0, 3);
        String replyText = reply.substring(4);
        FTPReply replyObj = new FTPReply(replyCode, replyText);
        if (replyCode.equals(expectedReplyCode)) {
            return replyObj;
        }
        throw new FTPException(replyText, replyCode);
    }

    FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        String replyCode = reply.substring(0, 3);
        String replyText = reply.substring(4);
        FTPReply replyObj = new FTPReply(replyCode, replyText);
        int i = 0;
        while (i < expectedReplyCodes.length) {
            if (replyCode.equals(expectedReplyCodes[i])) {
                return replyObj;
            }
            ++i;
        }
        throw new FTPException(replyText, replyCode);
    }

    void debugResponses(boolean on) {
        this.debugResponses = on;
    }

    void setLogStream(PrintWriter log) {
        if (log != null) {
            this.log = log;
        } else {
            this.debugResponses = false;
        }
    }

    void log(String msg) {
        if (this.debugResponses && this.log != null) {
            if (!msg.startsWith(PASSWORD_MESSAGE)) {
                this.log.println(msg);
            } else {
                this.log.println("---> PASS ********");
            }
        }
    }
}

