package org.tekkotsu.sketch;

import java.awt.Graphics2D;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import java.awt.PopupMenu;

import java.awt.Rectangle;
import java.awt.geom.*;

// stores info for a VisualObject

public class VisualObjectInfo {
    static Icon icon = new ImageIcon("org/tekkotsu/mon/icons/unknown.png");
    static Icon inverted_icon = null;
    int id;
    int parentId;
    String name;
    Color color;
    boolean isVisible;
    boolean inverted;

	public VisualObjectInfo(int _id, int _parentId, String _name, 
				Color _color){
		id = _id;
		parentId = _parentId;
		name = _name;
		color = _color;
	}

	public int getId() { return id; }
	public int getParentId() { return parentId; }
	public String getName() { return name; }

	public float getLeft() { return 0; }
	public float getRight() { return 176; }
	public float getTop() { return 0; }
	public float getBottom() { return 144; }

    public Color getColor() 
    { 
	if (inverted)
	    return new Color(255-color.getRed(),
				 255-color.getGreen(),
				 255-color.getBlue());
	else
	    return color; 
    }

    public Color getColorInverted()
    {
	return new Color(255-color.getRed(),
			 255-color.getGreen(),
			 255-color.getBlue());
    }

    public void setVisible(boolean vis) {
	isVisible = vis;
    }

    public boolean getVisible() {
	return isVisible;
    }
    
    public String toString() {
	return (name + "(id " + id + ", parentId " + parentId + ")");
    }

    public Icon getIcon() { 
	if (!inverted || inverted_icon == null)
	    return icon;
	else
	    return inverted_icon;
    }

    public void renderTo(Graphics2D graphics) {
	System.out.println("Rendering "+id);
    }
    
    public void renderTo(Graphics graphics, Rectangle2D.Double r) {}

    public void invert() {
	inverted = !inverted;
    }

    public void setInverted(boolean _inverted) {
	inverted = _inverted;
    }
    
}


