package org.tekkotsu.sketch;

import org.tekkotsu.mon.*;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.lang.String;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Date;
import java.util.Vector;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Comparator;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import java.io.File;
import java.net.*;
import java.io.*;
import java.util.StringTokenizer;
import java.awt.geom.*;



public class SketchGUI extends JFrame implements ActionListener,
						 TreeSelectionListener,
						 VisionUpdatedListener,
						 MouseListener
{
    //    boolean isCam; // true if this GUI is displaying a camera space (not world)
    int space;

    JFrame sketchFrame;
    SketchPanel sketchPanel;
    JButton rescaleBut;
    JButton refreshListBut;

    JTree sketchTree = null;
    DefaultMutableTreeNode root;
    JLabel status;
    float mspf=0;
    float mspfGamma = 0.9f;
    String state="";
    String host;
    int listingPort;
    int sketchPort;
    static Preferences prefs = Preferences.userNodeForPackage(SketchGUI.class);

    // the socket over which listings are retrieved and Sketch commands are sent
    Socket listingSocket=null;
    PrintWriter netout = null; // network output
    BufferedReader netin = null; // network input

    VisionListener listener;

    PopupMenu popMenu;
    VisualObjectInfo currentMenuObject;

    Vector sketchStack;
    BufferedImage img;
    boolean imageNeedsUpdate;
    TreeSelectionEvent lastEvent = null;

    SketchPanel curSketchPanel;

    public static void main(String args[]) {
	if(args.length<4)
	     usage();

	int _listingPort = Integer.parseInt(args[2]);
	int _sketchPort = Integer.parseInt(args[3]);
	
	//	boolean _isCam = args[1].equals("cam");
	int _space = args[1].equals("cam") ? 1 : (args[1].equals("local") ? 2 : 3);
	//	SketchGUI gui = new SketchGUI(args[0], _listingPort, _sketchPort, _isCam);
	SketchGUI gui = new SketchGUI(args[0], _listingPort, _sketchPort, _space);
	gui.addWindowListener(new WindowAdapter() {
		 public void windowClosing(WindowEvent e) {System.exit(0);}});
	gui.setVisible(true);
    }

    public static void usage() {
	System.out.println("Usage: java org/tekkotsu/mon/SketchGUI host [cam/world] listport sketchport");
	System.exit(2);
    }

    public void actionPerformed(ActionEvent e) {
	try {
	    if(e.getActionCommand().compareTo("rescale")==0)
		rescaleAction();
	    else if(e.getActionCommand().compareTo("refreshlist")==0)
		refreshlistAction();
	}
	catch(IOException ioe) {
	    System.err.println("Transfer error");
	    reconnect();
	    actionPerformed(e);
	}
    }

    public void rescaleAction() {
	// reset bounds **** THIS CODE ASSUMES ERS-2XX CAMERA DIMENSIONS; SHOULD FIX
	sketchPanel.leftBound = 0;
	sketchPanel.rightBound = 176;
	sketchPanel.topBound = 0;
	sketchPanel.bottomBound = 144;
	TreePath[] paths = sketchTree.getSelectionPaths();
	if(paths!=null) {
	    for (int path_i = 0; path_i < paths.length; path_i++) {
		DefaultMutableTreeNode node 
		    =(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());
		
		if (node == root) continue;
		if(!(node.getUserObject() instanceof VisualObjectInfo)) {
		    System.out.println("rescaleAction:: placeholder text can't be selected");
		    continue;
		}
		
		VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
		sketchPanel.scaleToVisualObject(vinfo);
		if (vinfo instanceof SketchInfo)
		    {
			((SketchInfo)vinfo).unloadImage();
		    }
	    }
	}
	valueChanged(null); // redraw
    }

    public void refreshlistAction() throws IOException {
	// send command to refresh the sketch tree list
	if(netout==null)
	    reconnect();
	if(netout==null)
	    return;
	root.removeAllChildren();
	sketchStack = new Vector();
	
	// reset bounds **** THIS CODE ASSUMES ERS-2XX CAMERA DIMENSIONS; SHOULD FIX
	sketchPanel.leftBound = 0;
	sketchPanel.rightBound = 176;
	sketchPanel.topBound = 0;
	sketchPanel.bottomBound = 144;
	
	// read in new sketch/shape list
	netout.println("list");
	String inputLine;
	System.out.println(inputLine = readLine());
	while((inputLine=readLine()).compareTo("list end") != 0) {
	    // parse type (sketch or shape)	
	    StringTokenizer st = new StringTokenizer(inputLine,": ");
	    String type = st.nextToken();
	    
	    // parse id
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    int id = Integer.parseInt(st.nextToken());
	    
	    //parse parentId
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    int parentId = Integer.parseInt(st.nextToken());
	    
	    // parse name
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,":\r\n");
	    st.nextToken();
	    String name = st.nextToken();
	    
	    // parse sketch or shape subtype
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    int subtype = Integer.parseInt(st.nextToken());
	    System.out.println(type+"type:" + subtype);
	    
	    // parse color
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    Color color = new Color( Integer.parseInt(st.nextToken()),
				     Integer.parseInt(st.nextToken()),
				     Integer.parseInt(st.nextToken()));
	    System.out.println("color: " + color);
	    
	    // create node
	    System.out.println(type + " id:"+id+"parentId:"+parentId+"name:"+name);
	    VisualObjectInfo oinfo;
	    if(type.equals("sketch")) 
		oinfo =  new SketchInfo(id, parentId, name, color, subtype);
	    else if (type.equals("shape"))
		oinfo = parseShape(id, parentId, name, color, subtype);
	    else {
		System.out.println("Invalid type!");
		color = new Color(0);
		oinfo = new VisualObjectInfo(id, parentId, name, color);
	    }
	    
	    //	    if (!isCam) sketchPanel.scaleToVisualObject(oinfo);
	    if (space != 1) sketchPanel.scaleToVisualObject(oinfo);
	    
	    DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(oinfo);
	    root.add(newnode);
	    
	    sketchTree.updateUI();
	}

	// pair children with parents
	DefaultMutableTreeNode curNode;
	Vector allnodes = new Vector();
	Enumeration nodeEn = root.preorderEnumeration();
	while(nodeEn.hasMoreElements()){
	    allnodes.add(nodeEn.nextElement());
	}
	for (int i=0; i<allnodes.size(); i++)
	    {
		curNode = (DefaultMutableTreeNode)(allnodes.elementAt(i));
		DefaultMutableTreeNode potentialParent = root;
		while((potentialParent = potentialParent.getNextNode()) != null) {
		    
		    if (curNode != root)
			{
			    if(((VisualObjectInfo)(curNode.getUserObject())).parentId == 
			       ((VisualObjectInfo)(potentialParent.getUserObject())).id && 
			       !potentialParent.isNodeAncestor(curNode)) {
				potentialParent.add(curNode);
				break;
			    }
			}
		}
		
	    }
	sortTree(root);
	
	// display the first sketch
	SketchInfo firstinfo = (SketchInfo)(((DefaultMutableTreeNode)(root.getFirstChild())).getUserObject());
	netout.println("get "+firstinfo.getId());
	while((inputLine=readLine()).compareTo("get end") != 0) {
	    System.out.println(inputLine);
	}	
	
	System.out.println(inputLine);
	for (int i = 0; i < sketchTree.getRowCount(); i++) {
	    sketchTree.expandRow(i);
	}
	sketchTree.clearSelection();
	sketchTree.updateUI();
    }
    
    public VisualObjectInfo parseShape(int id, int parentId, String name, Color color, int shapetype) 
	throws IOException
    {
	String inputLine;
	StringTokenizer st;
    
	inputLine = readLine();
	st = new StringTokenizer(inputLine,": ");
	st.nextToken();
	float cx = Float.parseFloat(st.nextToken());
	float cy = Float.parseFloat(st.nextToken());
	float cz = Float.parseFloat(st.nextToken());
	System.out.println("cxyz:" +cx+" "+cy+" "+cz);
    
	if(shapetype == 1) { // lineshape
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    float e1x = Float.parseFloat(st.nextToken());
	    float e1y = Float.parseFloat(st.nextToken());
	    float e1v = Float.parseFloat(st.nextToken());
	    System.out.println("e1xyv:"+e1x+" "+e1y +" "+e1v);
	    
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    float e2x = Float.parseFloat(st.nextToken());
	    float e2y = Float.parseFloat(st.nextToken());
	    float e2v = Float.parseFloat(st.nextToken());
	    System.out.println("e1xyv:"+e1x+" "+e1y +" "+e1v);
	    
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    float r = Float.parseFloat(st.nextToken());
	    System.out.println("r:"+r);
	    
	    inputLine = readLine();
	    st = new StringTokenizer(inputLine,": ");
	    st.nextToken();
	    float theta = Float.parseFloat(st.nextToken());
	    System.out.println("theta:"+theta);
	    
	    return new LineShapeInfo(id, parentId, name, color,
				     cx,cy,cz, e1x, e1y, e1v, e2x, e2y, e2v, r, theta);
	
    } else if(shapetype == 2) { // ellipseshape
	inputLine = readLine();
	st = new StringTokenizer(inputLine,": ");
	st.nextToken();
	float semimajor = Float.parseFloat(st.nextToken());
	float semiminor = Float.parseFloat(st.nextToken());
	System.out.println("axes:"+semimajor+" "+semiminor);
	
	inputLine = readLine();
	st = new StringTokenizer(inputLine,": ");
	st.nextToken();
	float orientation = Float.parseFloat(st.nextToken());
	System.out.println("orientation:"+orientation);
	
	return new EllipseShapeInfo(id,parentId,name,color,
				     cx,cy,cz, semimajor, semiminor, orientation);
	
    } else if (shapetype == 4) { // agentshape
	inputLine = readLine();
	st = new StringTokenizer(inputLine,": ");
	st.nextToken();
	float orientation = Float.parseFloat(st.nextToken());
	System.out.println("orientation:"+orientation);
	
	return new AgentShapeInfo(id,parentId, name, color,
				   cx,cy,cz, orientation);
    } else if (shapetype == 5) { // sphereshape
	inputLine = readLine();
	st = new StringTokenizer(inputLine,": ");
	st.nextToken();
	float radius = Float.parseFloat(st.nextToken());
	System.out.println("radius:"+radius);
	
	return new SphereShapeInfo(id,parentId,name,color,cx,cy,cz,radius);
    } else {
	System.out.println("Invalid shape!");
	return new ShapeInfo(id, parentId, name, color, cx, cy, cz);
    }
}

public SketchGUI(String host, int _listingPort, int _sketchPort, 
		 //		 boolean _isCam) {
		 int _space) {
    super();
    this.host = host;
    this.listingPort = _listingPort;
    this.sketchPort = _sketchPort;
    //    this.isCam = _isCam;
    this.space = _space;
    
    //    if(isCam)
    if(space == 1)
	root = new DefaultMutableTreeNode("camspace");
    else if (space == 2)
	root = new DefaultMutableTreeNode("localspace");
    else
	root = new DefaultMutableTreeNode("worldspace");

    img = new BufferedImage(VisionListener.DEFAULT_WIDTH, VisionListener.DEFAULT_HEIGHT, BufferedImage.TYPE_INT_RGB);
    Graphics2D g = img.createGraphics();
    // g.setBackground(Color.GRAY);
    g.clearRect(0,0,VisionListener.DEFAULT_WIDTH, VisionListener.DEFAULT_HEIGHT);
    sketchStack = new Vector();
    
    init();
    
    // network setup
    reconnect();
}
	
    public void init() {

	int strutsize=10;
	int sepsize=5;
	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(Box.createVerticalStrut(strutsize),BorderLayout.NORTH);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.WEST);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.EAST);
		
	//	setTitle("TekkotsuMon: "+(isCam ? "Cam" : "World")+" Space");
	setTitle("TekkotsuMon: "+((space==1) ? "Cam" : ((space==2) ? "Local" : "World"))+" Space");
	listener = new TCPVisionListener(host, sketchPort);
	//	sketchPanel = new SketchPanel(this, listener, isCam, prefs);
	sketchPanel = new SketchPanel(this, listener, space, prefs);
	sketchPanel.setMinimumSize(new Dimension(VisionListener.DEFAULT_WIDTH/2, VisionListener.DEFAULT_HEIGHT/2));
	sketchPanel.setPreferredSize(new Dimension(VisionListener.DEFAULT_WIDTH*2, VisionListener.DEFAULT_HEIGHT*2));
	sketchPanel.setLockAspectRatio(true);

	curSketchPanel = sketchPanel;
	//	sketchPanel.makeSketchFrame(sketchPanel, isCam ? "Cam" : "World");
	sketchPanel.makeSketchFrame(sketchPanel, (space==1) ? "Cam" : ((space==2) ? "Local" : "World"));
	{

	    Box tmp1 = Box.createHorizontalBox();
	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    {		Box tmp2 = Box.createVerticalBox();

		tmp2.add(Box.createVerticalStrut(strutsize));

		{
		    Box tmp3 = Box.createHorizontalBox();
		    tmp3.add(status=new JLabel(state));
		    tmp3.add(Box.createHorizontalGlue());

		    tmp3.add(Box.createHorizontalStrut(strutsize));
		
		    rescaleBut = new JButton("Rescale the Image");
		    rescaleBut.setAlignmentX(0.5f);
		    rescaleBut.addActionListener(this);
		    rescaleBut.setActionCommand("refresh");
		    rescaleBut.setEnabled(true);
		    rescaleBut.setToolTipText("Rescales the displayed sketch;");
		    tmp3.add(rescaleBut);
		    tmp3.add(Box.createHorizontalStrut(strutsize));

		    refreshListBut = new JButton("Refresh Listing");
		    refreshListBut.setAlignmentX(0.5f);
		    refreshListBut.addActionListener(this);
		    refreshListBut.setActionCommand("refreshlist");
		    refreshListBut.setEnabled(true);
		    refreshListBut.setToolTipText("Refreshes the sketch listing;");
		    tmp3.add(refreshListBut);
		    
		    tmp2.add(tmp3, BorderLayout.CENTER);
		}

		tmp2.add(Box.createVerticalStrut(strutsize));
		// Sketch Tree:
		sketchTree = new JTree(new DefaultTreeModel(initSketchTree(host, listingPort)));
		tmp2.add(new JScrollPane(sketchTree));
		// set up sketch node selection
		sketchTree.getSelectionModel().setSelectionMode
		            (TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
		//Listen for when the selection changes.
		sketchTree.addTreeSelectionListener(this);
		sketchTree.addMouseListener(this);
		sketchTree.setCellRenderer(new SketchTreeRenderer());

		tmp2.add(Box.createVerticalStrut(strutsize));
		{
		    Box tmp4 = Box.createHorizontalBox();
		    tmp4.add(status=new JLabel(state));
		    tmp4.add(Box.createHorizontalGlue());
		    tmp2.add(tmp4);
		}
		tmp2.add(Box.createVerticalStrut(strutsize));
		tmp1.add(tmp2);
	    }	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    getContentPane().add(tmp1,BorderLayout.CENTER);
	}
	pack();
	
	String name="SketchGUI"+".location";
	setLocation(prefs.getInt(name+".x",50),prefs.getInt(name+".y",50));
	addWindowListener(new CloseSketchGUIAdapter(this));

	sketchPanel.getListener().addListener(this);


	popMenu = new PopupMenu();
	MenuItem invBox = new MenuItem("Invert");
	invBox.addActionListener(new PopupInvertListener());
	popMenu.add(invBox);
	MenuItem newWindow = new MenuItem("Clone current window");
	newWindow.addActionListener(new PopupNewWindowListener(this));
	popMenu.add(newWindow);
	this.add(popMenu);
    }

    class CloseSketchGUIAdapter extends WindowAdapter {		SketchGUI gui;
	CloseSketchGUIAdapter(SketchGUI gui) {this.gui=gui;}
	public void windowClosing(WindowEvent e) {
	    gui.close();
	}
    }

    class PopupInvertListener implements ActionListener {
 	public void actionPerformed(ActionEvent e)
	{
	    currentMenuObject.invert();
	    valueChanged(lastEvent);
	    sketchTree.treeDidChange();
	}
    }

    class PopupNewWindowListener implements ActionListener {
	SketchGUI gui;

        public PopupNewWindowListener(SketchGUI _gui) { gui = _gui; }

	public void actionPerformed(ActionEvent e)
	{
	    //		 SketchPanel sketchPanel=new SketchPanel(gui, listener, true, prefs);
		 SketchPanel sketchPanel=new SketchPanel(gui, listener, 1, prefs);
	    sketchPanel.setMinimumSize(new Dimension(VisionListener.DEFAULT_WIDTH/2, 
							  VisionListener.DEFAULT_HEIGHT/2));
		 sketchPanel.setPreferredSize(new Dimension(VisionListener.DEFAULT_WIDTH*2, 
							    VisionListener.DEFAULT_HEIGHT*2));
		 sketchPanel.setLockAspectRatio(true);
		 
		 sketchPanel.makeSketchFrame(sketchPanel, "Cloned");
		 		 
		 sketchPanel.imageUpdated(getSketchImage(),sketchTree.getSelectionPaths());   
	}
    }

	public void close() {
		try {
			if(listingSocket!=null && !listingSocket.isClosed())
				listingSocket.close();		} catch (IOException ioe) {
			System.err.println("close failed:");
			ioe.printStackTrace();
		}
		prefs.putInt("SketchGUI.location.x",getLocation().x);
		prefs.putInt("SketchGUI.location.y",getLocation().y);
		sketchPanel.getListener().removeListener(this);
		Component p=sketchPanel;
		while(p.getParent()!=null)
			p=p.getParent();
		if(p instanceof Window) {
			Window w=(Window)p;
			prefs.putInt("SketchPanel.location.x",w.getLocation().x);
			prefs.putInt("SketchPanel.location.y",w.getLocation().y);
			w.dispose();
		} else
			System.out.println("That's weird - root container isn't window");
		dispose();
	}

    public TreeNode initSketchTree(String host, int port) {

	// Just for demonstration:
	DefaultMutableTreeNode cam = new DefaultMutableTreeNode("hit refresh");
	root.insert(cam,0);
	return root;
    }

    public void sortTree(DefaultMutableTreeNode curNode) {
		// set up comparator
		Comparator comp =
			new Comparator() {
				public int compare(Object o1, Object o2) {
					return compare((DefaultMutableTreeNode) o1, (DefaultMutableTreeNode) o2);  
				}
				public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
					Integer i1 = new Integer(((VisualObjectInfo)n1.getUserObject()).id);
					Integer i2 = new Integer(((VisualObjectInfo)n2.getUserObject()).id);
					return i1.compareTo(i2);
				}
			};

		// sort the roots children
		Object[] objs = new Object[curNode.getChildCount()];
		Enumeration children = curNode.children();
		for (int i=0;children.hasMoreElements();i++) {
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) children.nextElement();
			objs[i] = child;
		}

		Arrays.sort(objs, comp);
		curNode.removeAllChildren();

		// insert newly ordered children
		for (int i=0;i<objs.length;i++) {
			DefaultMutableTreeNode orderedNode = (DefaultMutableTreeNode) objs[i];
			curNode.add(orderedNode);
			if (!orderedNode.isLeaf()) {
				sortTree(orderedNode);
			}
		}
	}

	// gets called when a Sketch selection is clicked
    public void valueChanged(TreeSelectionEvent e) {
	imageNeedsUpdate = true;
	lastEvent = e;
	TreePath[] paths = sketchTree.getSelectionPaths();
	
	// Go through all objects and set visible to false
	DefaultMutableTreeNode n = root;
	while((n = n.getNextNode())!= null)
	    {
		((VisualObjectInfo)n.getUserObject()).setVisible(false);
	    }
	

	if (paths == null) {
	    //renderSelectedInTree(null);
	    curSketchPanel.imageUpdated(null, null);
	    return;
	}

	for (int path_i = 0; path_i < paths.length; path_i++) {
	    DefaultMutableTreeNode node 
		=(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());
	    
	    if (node == root) continue;	
	    if (node == null) {System.err.println("node is null???"); return; }
	    
	    if(!(node.getUserObject() instanceof VisualObjectInfo)) {
		System.out.println("valueChanged:: placeholder text can't be displayed");
		continue;
	    }
	    
	    
	    VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
	    if (!node.isRoot()) {
		System.out.println("id clicked:"+vinfo.id);
		if (! (vinfo instanceof SketchInfo) || ! ((SketchInfo)vinfo).isImageLoaded())
		    {
			((TCPVisionListener)listener).setReadingImage();
			netout.println("get "+vinfo.id);
			try {
			    String inputLine;
			    while((inputLine=readLine()).compareTo("get end") != 0) {
				System.out.println(inputLine);
			    }
			} catch (IOException ioe) {
			    System.err.println("Transfer error");
			    reconnect();
			    valueChanged(null);
			}
			if (vinfo instanceof SketchInfo)
			    {
				while(((TCPVisionListener)listener).isReadingImage())
				    ;
				((SketchInfo)vinfo).copyImage(((TCPVisionListener)listener).getImage());
			    }
			System.out.println("done with id:"+vinfo.id);
		    }
		vinfo.setVisible(true);
		if (!sketchStack.contains(vinfo)) { sketchStack.add(vinfo); }
	    } else {

	    }
	}
	
	curSketchPanel.imageUpdated(getSketchImage(), paths);
    }

    protected String readLine() throws java.io.IOException {
	if(netin==null)
	    reconnect();
	if(netin==null)
	    throw new java.io.IOException("no connection");
	String ans=netin.readLine();
	if(ans==null)
	    throw new java.io.IOException("lost connection");
	return ans;
    }
	
	public void reconnect() {
		System.out.print(host+":"+listingPort+" reconnecting...");
		try {
			if(listingSocket!=null && !listingSocket.isClosed())
				listingSocket.close();
			netin=null;
			netout=null;
			listingSocket = new Socket(host,listingPort);
			netout = new PrintWriter(listingSocket.getOutputStream(), true);
			netin = new BufferedReader(new InputStreamReader(listingSocket.getInputStream()));
		} catch (UnknownHostException e) {
			System.err.println("Don't know about host:"+host);
			System.exit(1);
		} catch (IOException ioe) {
			System.err.println("reconnection failed:");
			//ioe.printStackTrace();
			return;
		}
		System.out.println("done");
		refreshListBut.doClick(); //auto refresh on reconnect
	}

	public void visionUpdated(VisionListener listener) {
	    //renderSelectedInTree(l.getImage().createGraphics());
		listener.removeListener(this);
		listener.fireVisionUpdate();
		listener.addListener(this);
	}
	
	// renders all the currently selected elements in the tree
	public void renderSelectedInTree(Graphics2D g) {
		if(g==null) {
			g = img.createGraphics();
			// g.setBackground(Color.GRAY);
			g.clearRect(0,0,img.getWidth(),img.getHeight());
		}
		TreePath[] paths = sketchTree.getSelectionPaths();
		if (paths == null) {
			sketchPanel.repaint();
			return;
		}
		for (int path_i = 0; path_i < paths.length; path_i++) {
			DefaultMutableTreeNode node 
				=(DefaultMutableTreeNode)(paths[path_i].getLastPathComponent());

			if (node == root) continue;
			if (node == null) return;
			
			if(!(node.getUserObject() instanceof VisualObjectInfo)) {
				System.out.println("renderSelectedInTree:: placeholder text can't be displayed");
				continue;
			}
			
			VisualObjectInfo vinfo = (VisualObjectInfo)(node.getUserObject());
			g.setColor(vinfo.getColor());

			//g.setTransform(sketchPanel.resultAtrans);
			//vinfo.renderTo(g);
		}
		sketchPanel.repaint();
		//repaint(); // repaints this frame
		//paintAll(); // repaints everything in this frame
	}

    public void mousePressed(MouseEvent e)
    {
	TreePath selectedPath = sketchTree.getPathForLocation(e.getX(),e.getY());
	//System.out.println("Got mouse event for "+selectedPath);
	if (e.getButton() == MouseEvent.BUTTON3)
	    {
		if (selectedPath != null)
		    {
			currentMenuObject = ((VisualObjectInfo)(((DefaultMutableTreeNode)(selectedPath.getLastPathComponent())).getUserObject()));
			popMenu.show(sketchTree,e.getX(), e.getY());
		    }
	    }
    }

    public void mouseClicked(MouseEvent e){}
    public void mouseReleased(MouseEvent e){}
    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}

    public BufferedImage getSketchImage()
    {
	if (imageNeedsUpdate) createSketchImage();
	return img;
    }

    private void createSketchImage()
    {
	// Cull not visible objects from vector
	// render all the sketches in the vector

	img = new BufferedImage(VisionListener.DEFAULT_WIDTH, VisionListener.DEFAULT_HEIGHT, BufferedImage.TYPE_INT_RGB	);
	Graphics2D g = img.createGraphics();
	g.setBackground(Color.GRAY);
	g.clearRect(0,0,VisionListener.DEFAULT_WIDTH, VisionListener.DEFAULT_HEIGHT);

	int pixcount = img.getWidth()*img.getHeight();
	int rarr[] = new int[pixcount];
	int garr[] = new int[pixcount];
	int barr[] = new int[pixcount];
	int counts[] = new int[pixcount];
	for (int i=0; i < pixcount; i++)
	    {
		rarr[i] = 0;
		garr[i] = 0;
		barr[i] = 0;
		counts[i] = 0;
	    }

	// Draw SketchINTS
	for (int i=0; i<sketchStack.size(); i++)
	    {
		VisualObjectInfo vinfo = (VisualObjectInfo)sketchStack.elementAt(i);
		if (vinfo.getVisible()) {
		    if (vinfo instanceof SketchInfo && !((SketchInfo)vinfo).isSketchBool()) {
			((SketchInfo)vinfo).renderToArrays(rarr,garr,barr,counts);
		    }
		} else {
		    sketchStack.removeElementAt(i--);
		}
	    }

	for (int y=0; y<img.getHeight(); y++)
	    {
		for (int x=0; x<img.getWidth(); x++)
		    {
			int pos = y*img.getWidth()+x;
			if (counts[pos] > 0)
			    {
				g.setColor(new Color(rarr[pos]/counts[pos],
						     garr[pos]/counts[pos],
						     barr[pos]/counts[pos]));
				g.drawLine(x,y,x,y);
			    }
		    }
	    }


	// Draw SketchBOOLs
	for (int i=0; i < img.getWidth()*img.getHeight(); i++)
	    {
		rarr[i] = 0;
		garr[i] = 0;
		barr[i] = 0;
		counts[i] = 0;
	    }

	for (int i=0; i<sketchStack.size(); i++)
	    {
		VisualObjectInfo vinfo = (VisualObjectInfo)sketchStack.elementAt(i);
		if (vinfo.getVisible())
		    {
			if (vinfo instanceof SketchInfo && ((SketchInfo)vinfo).isSketchBool())
			    {
				((SketchInfo)vinfo).renderToArrays(rarr,garr,barr,counts);
			    }
		    }
		else
		    {
			sketchStack.removeElementAt(i--);
 		    }
	    }

	for (int y=0; y<img.getHeight(); y++)
	    {
		for (int x=0; x<img.getWidth(); x++)
		    {
			int pos = y*img.getWidth()+x;
			if (counts[pos] > 0)
			    {
				g.setColor(new Color(rarr[pos]/counts[pos],
						     garr[pos]/counts[pos],
						     barr[pos]/counts[pos]));
				g.drawLine(x,y,x,y);
			    }
		    }
	    }

	imageNeedsUpdate = false;

	//renderSelectedInTree(img.createGraphics());
    }

    public void setCurrentSketchPanel(SketchPanel s, TreePath[] paths)
    {
	if (curSketchPanel != s)
	    {
		curSketchPanel.loseFocus();
	    }
	curSketchPanel = s;
	if (sketchTree != null)
	    {
		sketchTree.setSelectionPaths(paths);
	    }
    }


	private class SketchTreeRenderer extends DefaultTreeCellRenderer {
		public SketchTreeRenderer(/*Icon icon*/) {
//			tutorialIcon = icon;
		}

		public Component getTreeCellRendererComponent(
				JTree tree,
				Object value,
				boolean sel,
				boolean expanded,
				boolean leaf,
				int row,
				boolean hasFocus) {
			super.getTreeCellRendererComponent(
					tree, value, sel,
					expanded, leaf, row,
					hasFocus);
			try {
			VisualObjectInfo vinfo = (VisualObjectInfo)(((DefaultMutableTreeNode)value).getUserObject());
			
			setIcon(vinfo.getIcon());
			setToolTipText(vinfo.toString());
			} catch (ClassCastException e) {}

			return this;
		}
	}
}
