package org.tekkotsu.sketch;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AgentShapeInfo extends ShapeInfo {
	static Icon icon = new ImageIcon("org/tekkotsu/mon/icons/agent.png");
	float orientation; // orientation of agent

	public AgentShapeInfo(int _id, int _parentId, String _name, Color _color,
			float _centroidx, float _centroidy, float _centroidz,
			float _orientation) {
		super(_id, _parentId, _name, _color, _centroidx,_centroidy, _centroidz);
		orientation = _orientation;
	}

	// returns left-most coordinate of object (want some buffer)
	public float getLeft() { return centroidx-2; }
	// returns right-most coordinate of object
	public float getRight() { return centroidx+2; }
	// returns top-most coordinate of object
	public float getTop() { return centroidy-2; }
	// returns bottom-most coordinate of object
	public float getBottom() { return centroidy+2; }

	public String toString() {
		return (super.toString() + "(orientation " + orientation + ")");
	}	
	
	public Icon getIcon() { return icon; }

	public void renderTo(Graphics2D graphics) {
		graphics.drawOval((int)(getCentroidX()+1),
			(int)(getCentroidY()+1), 5, 5);
	}

	public float getOrientation() { return orientation; }
}

