package org.tekkotsu.mon;

import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

// stores info for a LineShape
public class LineShapeInfo extends ShapeInfo {
	static Icon icon = new ImageIcon("org/tekkotsu/mon/icons/line.png");
	// x/y coordinates of endpoints, with variances
	float e1x, e1y, e1v;
	float e2x, e2y, e2v;
	float r, theta;

	public LineShapeInfo(int _id, int _parentId, String _name, int _color,
			float _centroidx, float _centroidy, float _centroidz,
			float _e1x, float _e1y, float _e1v, 
			float _e2x, float _e2y, float _e2v,
			float _r, float _theta) {
		
		super(_id, _parentId, _name, _color, _centroidx, _centroidy, _centroidz);
		e1x = _e1x;
		e1y = _e1y;
		e1v = _e1v;
		e2x = _e2x;
		e2y = _e2y;
		e2v = _e2v;
		r = _r;
		theta = _theta;
	}
	
	// returns left-most coordinate of object
	public float getLeft() { return java.lang.Math.min(e1x,e2x); }
	// returns right-most coordinate of object
	public float getRight() { return java.lang.Math.max(e1x,e2x); }
	// returns top-most coordinate of object
	public float getTop() { return java.lang.Math.min(e1y,e2y); }
	// returns bottom-most coordinate of object
	public float getBottom() { return java.lang.Math.max(e1y,e2y); }

	public String toString() {
		return (super.toString() 
				+ "(e1x " +e1x + ", e1y " + e1y + ", e1v " + e1v 
				+ ", e2x " +e2x + ", e2y " + e2y + ", e2v " + e2v 
				+ ", r " + r + ", theta " + theta + ")");
	}

	public Icon getIcon() { return icon; }

	public void renderTo(Graphics2D graphics) {
		graphics.drawLine((int)e1x,(int)e1y,(int)e2x,(int)e2y);
		// draw circles for variance
		graphics.drawOval((int)e1x,(int)e1y,(int)(e1v/2),(int)(e1v/2));
		graphics.drawOval((int)e2x,(int)e2y,(int)(e2v/2),(int)(e2v/2));
	}

	public float getE1X() { return e1x; }
	public float getE1Y() { return e1y; }
	public float getE1V() { return e1v; }
	public float getE2X() { return e2x; }
	public float getE2Y() { return e2y; }
	public float getE2V() { return e2v; }
	public float getR() { return r; }
	public float getTheta() { return theta; }
}
