package org.tekkotsu.mon;

import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

// stores info for a EllipseShape
// note that ellipse center is same as centroid
public class EllipseShapeInfo extends ShapeInfo {
	static Icon icon = new ImageIcon("org/tekkotsu/mon/icons/ellipse.png");
	float semimajor, semiminor; // length of semimajor axes
	float orientation; // orientation of principal axis

	public EllipseShapeInfo(int _id, int _parentId, String _name, int _color,
			float _centroidx, float _centroidy, float _centroidz,
			float _semimajor, float _semiminor,
			float _orientation) {
		super(_id, _parentId, _name, _color, _centroidx, _centroidy, _centroidz);
		semimajor = _semimajor;
		semiminor = _semiminor;
		orientation = _orientation;
	}

	// returns left-most coordinate of object
	public float getLeft() { return centroidx-semimajor; }
	// returns right-most coordinate of object
	public float getRight() { return centroidx+semimajor; }
	// returns top-most coordinate of object
	public float getTop() { return centroidy-semiminor; }
	// returns bottom-most coordinate of object
	public float getBottom() { return centroidy+semiminor; }


	public String toString() {
		return (super.toString() + "(semimajor " + semimajor 
			+ ", semiminor " + semiminor 
			+ ", orientation " + orientation + ")");
	}

	public Icon getIcon() { return icon; }

	// rough rendering which doesn't take orientation into account
	public void renderTo(Graphics2D graphics) {
		// maybe do a hack-ish check if abs(orientation) more than pi/4?
		graphics.drawOval((int)(getCentroidX()-semimajor+1), 
			(int)(getCentroidY()-semiminor+1),
			(int)(semimajor*2), (int)(semiminor*2));
	}

	public float getSemiMajor() { return semimajor; }
	public float getSemiMinor() { return semiminor; }
	public float getOrientation() { return orientation; }
}
