package org.tekkotsu.mon;

import javax.swing.SwingConstants;
import javax.swing.JLabel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.FontMetrics;
import java.awt.geom.AffineTransform;

public class SketchPanel extends VisionPanel {
	SketchGUI gui; // reference back to owning SketchGUI
	AffineTransform atrans;
	AffineTransform resultAtrans;
	boolean isCam;

	// coordinate bounds for the view of the SketchPanel
	float leftBound=0, rightBound=176, topBound=0, bottomBound=144;

	protected SketchPanel(SketchGUI _gui, VisionListener listener, 
			boolean _isCam) {
		super(listener);
		gui = _gui;
		isCam = _isCam;
		//listener.run();
	}	
	
	public void visionUpdated(VisionListener l) {
		super.visionUpdated(l);
	}
	
	protected void drawImage(Graphics _g, BufferedImage img, int x, int y, 
			int w, int h) {
		Graphics2D g2d = (Graphics2D)_g;
		float scaling =java.lang.Math.min(img.getWidth()/(rightBound-leftBound),
				img.getHeight()/(bottomBound-topBound));
		if(isCam) {
			atrans = new AffineTransform(1*scaling,0,0,1*scaling,
					-leftBound*scaling,-topBound*scaling);
		} else {
			atrans = new AffineTransform(1*scaling,0,0,-1*scaling,
					-leftBound*scaling,bottomBound*scaling);

		}
		AffineTransform origtrans = g2d.getTransform();
		g2d.transform(atrans);
		resultAtrans = g2d.getTransform();
		//g2d.scale(scale,scale);
		//g2d.translate(leftBound, topBound);
//		System.out.println(g2d.getTransform().toString());
		
		//buf = new BufferedImage(500,500,BufferedImage.TYPE_BYTE_INDEXED);
		//buf.setData(img.getRaster());

		if(img!=null) {
			g2d.setTransform(origtrans);
			g2d.drawImage(img,x,y,w,h,null);
	//		g2d.drawImage(img,x,y,(int)(w*scaling),(int)(h*scaling),null);
			//g2d.drawImage(img,x,y,null);
			//g2d.drawImage(img, atrans,null);
		} else {
			g2d.setColor(getBackground());
			g2d.fillRect(x,y,w,h);
			FontMetrics tmp=g2d.getFontMetrics();
			String msg="No image";
			int strw=tmp.stringWidth(msg);
			int strh=tmp.getHeight();
			g2d.setColor(getForeground());
			g2d.drawString(msg,(getSize().width-strw)/2,(getSize().height-strh)/2+tmp.getAscent());
		}
	
		// redraw shapes if necessary
		//gui.renderSelectedInTree(g2d);

		// draw coordinates
		if (isCam) {
			g2d.setColor(getForeground());
			FontMetrics tmp=g2d.getFontMetrics();
			String msg="("+String.valueOf((int)leftBound)+","+String.valueOf((int)topBound)+")";
			int strw=tmp.stringWidth(msg);
			g2d.drawString(msg,x,y+tmp.getAscent());
			msg="("+String.valueOf((int)rightBound)+","+String.valueOf((int)bottomBound)+")";
			strw=tmp.stringWidth(msg);
			g2d.drawString(msg,x+w-strw,y+h-tmp.getDescent());
		} else {
			g2d.setColor(getForeground());
			FontMetrics tmp=g2d.getFontMetrics();
			int strh=tmp.getHeight();
			String msg="("+String.valueOf((int)leftBound)+","+String.valueOf((int)bottomBound)+")";
			int strw=tmp.stringWidth(msg);
			g2d.drawString(msg,x,y+tmp.getAscent());
			msg="("+String.valueOf((int)rightBound)+","+String.valueOf((int)topBound)+")";
			strw=tmp.stringWidth(msg);
			g2d.drawString(msg,x+w-strw,y+h-tmp.getDescent());
		}

	}

	// stretches the view of the SketchPanel to accomodate the specified object 
	public void scaleToVisualObject(VisualObjectInfo oinfo) {
		if(oinfo.getLeft() < leftBound)
			leftBound = oinfo.getLeft();
		if(oinfo.getRight() > rightBound)
			rightBound = oinfo.getRight();
		if(oinfo.getTop() < topBound)
			topBound = oinfo.getTop();
		if(oinfo.getBottom() > bottomBound)
			bottomBound = oinfo.getBottom();
	}
}
