package org.tekkotsu.mon;

import java.awt.event.*;
import javax.swing.*;
import java.lang.String;
import java.util.LinkedList;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.DataBuffer;
import java.util.Date;
import java.io.PrintWriter;
import java.io.FileOutputStream;

public class ImageSequenceWriterThread extends Thread implements VisionUpdatedListener {
	String dir;
	String pre;
	String post;
	String fmt;
	LinkedList imgBufs=new LinkedList();
	int dig;
	LinkedList q=new LinkedList();
	int count=0;
	VisionListener listen;
	boolean stopping=false;
	JButton but;
	boolean isYUVMode;

	public ImageSequenceWriterThread(VisionListener l, JButton reenableBut, boolean YUVmode) {
		super("ImageSequenceWriter");
		isYUVMode=YUVmode;
		int initbufsize=250;
		but=reenableBut;
		listen=l;
		l.addListener(this);
		BufferedImage i=l.getImage();
		if(i.getColorModel().getTransferType()!=DataBuffer.TYPE_BYTE)
			for(int j=0;j<initbufsize;j++)
				imgBufs.add(new BufferedImage(i.getWidth(),i.getHeight(),i.getType()));
		else {
			for(int j=0;j<initbufsize;j++)
				imgBufs.add(new BufferedImage(i.getWidth(),i.getHeight(),i.getType(),(IndexColorModel)i.getColorModel()));
		}
	}

	public void setDirectory(String directory) {
		dir=directory;
		if(dir.charAt(dir.length()-1)!='/')
			dir+='/';
	}

	public void setName(String prepend, int digits, String append, String format) {
		pre=prepend;
		post=append;
		fmt=format;
		dig=digits;
	}

	public void visionUpdated(VisionListener l) {
		if(fmt==null)
			return;
		if(!isYUVMode && l.hasRawJPEG() && (fmt.equalsIgnoreCase("jpg") || fmt.equalsIgnoreCase("jpeg")))
			push(l.getJPEG(),l.getJPEGLen(),l.getTimeStamp(),l.getFrameNum());
		else
			push(l.getImage(),l.getTimeStamp(),l.getFrameNum());
	}

	public void push(byte[] jpeg, int len, Date t, long frameNum) {
		byte[] jpegcopy = new byte[len];
		for(int i=0; i<len; i++)
			jpegcopy[i]=jpeg[i];
		synchronized(q) {
			q.addLast(new Boolean(true));
			q.addLast(jpegcopy);
			q.addLast(t);
			q.addLast(new Long(frameNum));
		}
	}

	public void push(BufferedImage i, Date t, long frameNum) {
		BufferedImage i2;
		if(imgBufs.size()>0)
			i2=(BufferedImage)imgBufs.removeFirst();
		else {
			if(i.getColorModel().getTransferType()!=BufferedImage.TYPE_BYTE_INDEXED)
				i2=new BufferedImage(i.getWidth(),i.getHeight(),i.getType());
			else
				i2=new BufferedImage(i.getWidth(),i.getHeight(),i.getType(),(IndexColorModel)i.getColorModel());
		}
		i.copyData(i2.getRaster());
		synchronized(q) {
			q.addLast(new Boolean(false));
			q.addLast(i2);
			q.addLast(t);
			q.addLast(new Long(frameNum));
		}
	}

	public void run() {
		String tmp=null;
		PrintWriter log=null;
		try {
			log=new PrintWriter(new FileOutputStream(dir+pre+post+".txt"));
		} catch(Exception ex) { ex.printStackTrace(); return; }
		Date start=null;
		long startFrame=0;
		try {
			while(true) {
				while(q.size()>0) {
					if(interrupted()) {
						if(!stopping) {
							stopping=true;
							if(but!=null) {
								but.setEnabled(false);
								tmp=but.getText();
								but.setText("Writing...");
							}
							listen.removeListener(this);
						} else { //second interrupt... die!
							break;
						}
					}
					BufferedImage i;
					byte[] jpeg;
					Date t;
					long num;
					synchronized(q) {
						if(((Boolean)q.removeFirst()).booleanValue()) { //is a jpeg
							jpeg=(byte[])q.removeFirst();
							i=null;
						} else {
							i=(BufferedImage)q.removeFirst();
							jpeg=null;
						}
						t=(Date)q.removeFirst();
						num=((Long)q.removeFirst()).longValue();
					}
					if(start==null) {
						start=t;
						startFrame=num;
						log.println("First frame "+startFrame+" timestamp: "+start.getTime());
					}
					long dt=t.getTime()-start.getTime();
					long df=num-startFrame;
					String name=getFileName(dt,df);
					if(log!=null)
						log.println(name+"\t"+count+"\t"+df+"\t"+dt);
					FileOutputStream fileout=new FileOutputStream(dir+name);
					if(i!=null) {
						ImageIO.write(i,fmt,fileout);
						imgBufs.addLast(i);
					} else if(jpeg!=null) {
						fileout.write(jpeg);
					}
					count++;
				}
				if(stopping)
					break;
				sleep(1000/30);
			}
		} catch(Exception ex) {
			listen.removeListener(this);
			if((InterruptedException)ex==null)
				ex.printStackTrace();
		}
		if(log!=null)
			log.close();
		if(but!=null && tmp!=null) {
			but.setEnabled(true);
			if(but.getText().compareTo("Writing...")==0)
				but.setText(tmp);
		}
	}

	protected String getFileName(long dt,long num) {
		String ans=pre;
		long c=num;
		int digits=dig;
		if(digits==0) {
			c=dt;
			digits=6;
		}
		for(int s=(int)Math.pow(10,digits-1); s>=1; s/=10) {
			ans+=c/s;
			c-=(c/s)*s;
		}
		ans+=post+"."+fmt;
		return ans;
	}
}
