package org.tekkotsu.mon;

import java.awt.Graphics2D;

// stores info for a Shape, to use as UserObject for DefaultMutableTreeNode
public class ShapeInfo extends VisualObjectInfo {
	float centroidx, centroidy, centroidz;
	int color; // the color index of this object

	public ShapeInfo(int _id, int _parentId, String _name, int _color,
			float _centroidx, float _centroidy, float _centroidz) {
		super(_id, _parentId, _name);
		centroidx = _centroidx;
		centroidy = _centroidy;
		centroidz = _centroidz;
		color = _color;
	}

	public String toString() {
		return (super.toString() + "(color " + color + ",cx " + centroidx + ", cy " + centroidy
			+ ", cz " + centroidz + ")");
	}

	// if no specific renderer defined, just plot a point at centroid
	public void renderTo(Graphics2D graphics) {
//		graphics.setColor()
		graphics.drawOval((int)centroidx,(int)centroidy,5,5);
	}

	public float getCentroidX() { return centroidx; }
	public float getCentroidY() { return centroidy; }
	public float getCentroidZ() { return centroidz; }
	public int getColor() { return color; }
}

