/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.IOException;

public class FTPClientTest {
    private static String cvsId = "$Id: FTPClientTest.java,v 1.3 2002/11/19 22:00:41 bruceb Exp $";

    public static void main(String[] args) {
        if (args.length < 7) {
            System.out.println(args.length);
            FTPClientTest.usage();
            System.exit(1);
        }
        try {
            String host = args[0];
            String user = args[1];
            String password = args[2];
            String filename = args[3];
            String directory = args[4];
            String mode = args[5];
            String connMode = args[6];
            FTPClient ftp = new FTPClient(host, 21);
            ftp.login(user, password);
            ftp.quit();
            ftp = new FTPClient(host);
            ftp.debugResponses(true);
            ftp.login(user, password);
            if (args[5].equalsIgnoreCase("BINARY")) {
                ftp.setType(FTPTransferType.BINARY);
            } else if (args[5].equalsIgnoreCase("ASCII")) {
                ftp.setType(FTPTransferType.ASCII);
            } else {
                System.out.println("Unknown transfer type: " + args[5]);
                System.exit(-1);
            }
            if (args[6].equalsIgnoreCase("PASV")) {
                ftp.setConnectMode(FTPConnectMode.PASV);
            } else if (args[6].equalsIgnoreCase("ACTIVE")) {
                ftp.setConnectMode(FTPConnectMode.ACTIVE);
            } else {
                System.out.println("Unknown connect mode: " + args[6]);
                System.exit(-1);
            }
            ftp.chdir(directory);
            ftp.put(filename, filename);
            byte[] buf = ftp.get(filename);
            System.out.println("Got " + buf.length + " bytes");
            try {
                ftp.put(filename, filename, true);
            }
            catch (FTPException ex) {
                System.out.println("Append failed: " + ex.getMessage());
            }
            buf = ftp.get(filename);
            System.out.println("Got " + buf.length + " bytes");
            ftp.rename(filename, filename + ".new");
            ftp.get(filename + ".tst", filename + ".new");
            ftp.setType(FTPTransferType.ASCII);
            String listing = ftp.list(".");
            System.out.println(listing);
            String[] listings = ftp.dir(".", true);
            int i = 0;
            while (i < listings.length) {
                System.out.println(listings[i]);
                ++i;
            }
            System.out.println(ftp.system());
            System.out.println(ftp.pwd());
            ftp.quit();
        }
        catch (IOException ex) {
            System.out.println("Caught exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            System.out.println("Caught exception: " + ex.getMessage());
        }
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("com.enterprisedt.net.ftp.FTPClientTest remotehost user password filename directory (ascii|binary) (active|pasv)");
    }
}

