package org.tekkotsu.mon;

import java.io.InputStream;
import java.net.Socket;

public class WorldStateJointsListener extends TCPListener {
  boolean _updatedFlag=false;
  Joints _data;
  Joints _outd;

  public void connected(Socket socket) {
    _isConnected=true;
    _data=new Joints();
    _outd=new Joints();
    try {
      InputStream in=socket.getInputStream();
      while (true) {
        _data.timestamp=readInt(in);
        for (int i=0; i<18; i++)
          _data.positions[i]=readFloat(in);
        for (int i=0; i<6; i++)
          _data.sensors[i]=readFloat(in);
        for (int i=0; i<8; i++)
          _data.buttons[i]=readFloat(in);
        for (int i=0; i<18; i++)
          _data.duties[i]=readFloat(in);

        synchronized(_outd) {
          Joints temp=_data;
          _data=_outd;
          _outd=temp;
          _updatedFlag=true;
        }
      }
    } catch (Exception ex) { }

    try { socket.close(); } catch (Exception ex) { }
    _isConnected=false;
  }
 
  public boolean hasData() {
    return _updatedFlag;
  }

  public Joints getData() {
    synchronized (_outd) {
      _updatedFlag=false;
      return _outd;
    }
  }

  public boolean isConnected() {
    return _isConnected;
  }

  public WorldStateJointsListener() { super(); }
  public WorldStateJointsListener(int port) { super(port); }
  public WorldStateJointsListener(String host, int port) { super(host,port); }
}
