package org.tekkotsu.mon;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*;
import java.util.*;
import java.util.prefs.Preferences;
import java.io.PrintWriter;
import java.io.FileWriter;

//Admittedly a little sloppy, but I don't want to spend forever on this...

public class ControllerGUI extends JFrame implements ActionListener, KeyListener {
	JList menu;
	JScrollPane menuScroll;
	JLabel title;
	JLabel status;
	JList scripts;
	ControllerListener comm;
	JButton backBut;
	JButton refreshBut;
	JButton reconnectBut;
	EStopButton estop;
	JTextField inputField;
	boolean isUpdating=false;
	DefaultListModel scriptsModel=new DefaultListModel();
  Vector inputFieldHistory;
  int inputFieldLocation;
	static Preferences prefs = Preferences.userNodeForPackage(ControllerGUI.class);
	final static int MAX_STORE_INPUT_HIST=20;
	
	ControllerGUI(String addr, int port) {
		super();
		comm = new ControllerListener(addr,port);
		comm.listener=this;
		init();
	}

	// Disables the component if there's nothing selected to apply it to
	public class AutoDisableListener implements PropertyChangeListener, ListSelectionListener {
		JComponent target;
		public AutoDisableListener(JComponent target, JList source) {
			this.target=target;
			source.addPropertyChangeListener(this);
			source.addListSelectionListener(this);
		}
		public void propertyChange(PropertyChangeEvent evt) {
			int min=((JList)evt.getSource()).getMinSelectionIndex();
			int max=((JList)evt.getSource()).getMaxSelectionIndex();
			//target.setEnabled(!((JList)evt.getSource()).isSelectionEmpty());
			target.setEnabled(min!=-1 && max-min==0);
		}
		public void valueChanged(ListSelectionEvent evt) {
			int min=((JList)evt.getSource()).getMinSelectionIndex();
			int max=((JList)evt.getSource()).getMaxSelectionIndex();
			//target.setEnabled(!((JList)evt.getSource()).isSelectionEmpty());
			target.setEnabled(min!=-1 && max-min==0);
		}
	}
	
	final static ImageIcon rarrow = new ImageIcon("images/rarrow.gif");
	final static ImageIcon larrow = new ImageIcon("images/larrow.gif");
	final static ImageIcon carrows = new ImageIcon("images/chasingarrows.gif");

	public class MyCellRenderer implements ListCellRenderer {
		public Component getListCellRendererComponent(JList list,Object value,int index,boolean isSelected,boolean cellHasFocus) {
			ControllerListener.MenuEntry me=(ControllerListener.MenuEntry)value;
			/*			if(me.hasSubmenu) {
						setIcon(rarrow);
						setHorizontalTextPosition(SwingConstants.RIGHT);
						setIconTextGap(5);
						} else
						setIconTextGap(5+rarrow.getIconWidth());
			*/			
			//System.out.println(this.getText()+" "+me.selected+" "+isSelected);
			int numpre=(int)(Math.log(list.getModel().getSize()-1)/Math.log(10))-(index==0?0:(int)(Math.log(index)/Math.log(10)));
			StringBuffer pre=new StringBuffer();
			for(int i=0;i<numpre;i++)
				pre.append(" ");
			JLabel title=new JLabel(pre.toString()+index+". "+me.title);
			title.setBackground(me.selected?list.getSelectionBackground():list.getBackground());
			title.setForeground(me.selected?list.getSelectionForeground():list.getForeground());
			title.setEnabled(list.isEnabled());
			title.setFont(list.getFont());
			title.setOpaque(true);
			title.setPreferredSize(new Dimension(list.getSize().width,title.getPreferredSize().height));
			//Vector tmp2=new Vector();
			//for(int i=0;i<1000000;i++) {tmp2.add(new Integer(0));tmp2.remove(tmp2.size()-1);}
			if(cellHasFocus)
				title.setBorder(BorderFactory.createLineBorder(Color.GRAY,1));
			else
				title.setBorder(BorderFactory.createEmptyBorder(1,1,1,1));
			if(me.hasSubmenu) {
				Box tmp=Box.createHorizontalBox();
				tmp.add(title);
				//				tmp.add(Box.createHorizontalGlue());
				JLabel arr=new JLabel(rarrow);
				arr.setEnabled(list.isEnabled());
				tmp.add(arr);
				if(me.description.length()!=0)
					tmp.setToolTipText(me.description);
				return tmp;
			} else {
				Box tmp=Box.createHorizontalBox();
				tmp.add(title);
				tmp.add(Box.createHorizontalStrut(rarrow.getIconWidth()));
				if(me.description.length()!=0)
					tmp.setToolTipText(me.description);
				return tmp;
			}
		}
	} 
	 
	public class JListDoubleClick extends MouseAdapter {
		ControllerGUI gui;
		JListDoubleClick(ControllerGUI gui) { this.gui=gui; }
		public void mouseClicked(MouseEvent e) {
			if (e.getClickCount() == 2) {
				int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
				gui.doubleClicked((JList)e.getSource(),index);
			}
		}
	}

	public class MySelectionListener implements ListSelectionListener {
		ControllerGUI gui;
		MySelectionListener(ControllerGUI gui) { this.gui=gui; }
		public void valueChanged(ListSelectionEvent e) {
			if(!gui.isUpdating && !e.getValueIsAdjusting())
				gui.comm.sendSelection(((JList)e.getSource()).getSelectedIndices());
		}
	}
 	
	public class EscFilter extends KeyAdapter {
		JButton trigger;
		EscFilter(JButton trigger) { this.trigger=trigger; }
		public void keyReleased(KeyEvent evt) {
			if(evt.getKeyCode()==KeyEvent.VK_ESCAPE)
				trigger.doClick();
		}
	}
	public class DelFilter extends KeyAdapter {
		ControllerGUI gui;
		DelFilter(ControllerGUI gui) { this.gui=gui; }
		public void keyReleased(KeyEvent evt) {
			if(evt.getKeyCode()==KeyEvent.VK_BACK_SPACE || evt.getKeyCode()==KeyEvent.VK_DELETE)
				gui.actionPerformed(new ActionEvent(evt.getSource(),0,"delbookmark"));
		}
	}
	public class ReturnFilter extends KeyAdapter {
		ControllerGUI gui;
		ReturnFilter(ControllerGUI gui) { this.gui=gui; }
		public void keyReleased(KeyEvent evt) {
			if(evt.getKeyCode()==KeyEvent.VK_ENTER)
				gui.doubleClicked((JList)evt.getSource(),0);
		}
	}
 	
	public class ReenableOnClose extends WindowAdapter {
		JButton but;
		public ReenableOnClose(JButton b) { but=b; }
		public void windowClosing(WindowEvent e) {
			if(but.getActionCommand().equals("raw"))
				comm.sendInput("!root \"TekkotsuMon\" \"RawCamServer\"");
			else
				comm.sendInput("!root \"TekkotsuMon\" \"SegCamServer\"");
			e.getWindow().dispose();
			but.setEnabled(true);
		}
	}

	void lostConnection() {
		updated();
	}

	void updated() {
			//		System.out.println("updated");
		isUpdating=true;
		Point p=menuScroll.getViewport().getViewPosition();  

		//scripts.setEnabled(comm._isConnected);
		backBut.setEnabled(comm._isConnected);
		refreshBut.setEnabled(comm._isConnected);
		inputField.setEnabled(comm._isConnected);
		if(!comm._isConnected) {
			title.setText("-");
			menu.setListData(new Vector());
			status.setText("Reconnecting...");
		} else {
			if(comm._connectCount>0) {
				if(comm._connectCount==1)
					for(int i=0; i<scriptsModel.getSize(); i++)
						if(scriptsModel.get(i).toString().equals("STARTUP"))
							comm.sendInput(((ScriptEntry)scriptsModel.get(i)).cmd);
				for(int i=0; i<scriptsModel.getSize(); i++)
					if(scriptsModel.get(i).toString().equals("CONNECT"))
						comm.sendInput(((ScriptEntry)scriptsModel.get(i)).cmd);
				comm._connectCount=-1; //so we don't get it again
			}
			synchronized(comm._menus) {
				title.setText((String)comm._titles.lastElement());
				Vector menuitems=(Vector)comm._menus.lastElement();
				menu.setValueIsAdjusting(true);
				menu.setListData((Vector)menuitems.clone());
				Vector sels=new Vector();
				for(int i=0; i<menuitems.size(); i++)
					if(((ControllerListener.MenuEntry)menuitems.get(i)).selected)
						sels.add(new Integer(i));
				int[] selsArr=new int[sels.size()];
				for(int i=0; i<selsArr.length; i++)
					selsArr[i]=((Integer)sels.get(i)).intValue();
				menu.setSelectedIndices(selsArr);
				menu.setValueIsAdjusting(false);
			}
			status.setText(comm._status.length()>0?comm._status:"Connected.");
		}
		menuScroll.getViewport().setViewPosition(p);
		isUpdating=false;
		comm._updatedFlag=false;
	}

	public void paint(Graphics g) {
		if(comm!=null && comm._updatedFlag)
			updated();
		super.paint(g);
	}
	
	public void actionPerformed(ActionEvent evt) {
		if(evt.getSource()==backBut) {
			//System.out.println("back button clicked");
			comm.sendReturn();
		} else if(evt.getSource()==refreshBut) {
			//System.out.println("refresh button clicked");
			comm.sendRefresh();
		} else if(evt.getSource()==inputField) {
			//System.out.println("input: "+inputField.getText());
			int[] sel=menu.getSelectedIndices();
      if (inputField.getText().length()==0) {
			} else if(sel.length==0 || inputField.getText().charAt(0)=='!')
				comm.sendInput(inputField.getText());
			else
				comm.sendInput("!input "+inputField.getText());
			/*else if(sel.length==1) {
				comm.sendSelectionPath(comm.buildSelectionPath(sel[0]));
				comm.sendInput(inputField.getText());
			} else
				for(int i=0; i<sel.length; i++)
					comm.sendInput(inputField.getText(),comm.buildSelectionPath(sel[i]));
			*/
      inputFieldHistory.add(inputField.getText());
      inputFieldLocation=inputFieldHistory.size();
			inputField.setText("");
		} else if(evt.getSource()==reconnectBut) {
			int port=comm._port;
			String addr=comm._host;
			comm.kill();
			comm = new ControllerListener(addr,port);
			comm.listener=this;
			estop.close();
			estop.open();
		} else if(evt.getActionCommand().equals("raw") || evt.getActionCommand().equals("rle")) {
			if(evt.getActionCommand().equals("raw"))
				comm.sendInput("!root \"TekkotsuMon\" \"RawCamServer\"");
			else
				comm.sendInput("!root \"TekkotsuMon\" \"SegCamServer\"");
			String[] tmp=new String[1];
			tmp[0]=evt.getActionCommand();
			VisionGUI vis=new VisionGUI(comm._host,tmp);
			((JButton)evt.getSource()).setEnabled(false);
			vis.addWindowListener(new ReenableOnClose((JButton)evt.getSource()));
			vis.show();
			vis.toFront();
		} else if(evt.getActionCommand().equals("addbookmark")) {
			int sel=comm.firstSelected();
			if(sel==-1 || !comm._isConnected) {
				scriptsModel.addElement(new ScriptEntry("",""));
			} else {
				String title=((ControllerListener.MenuEntry)((Vector)comm._menus.lastElement()).get(menu.getMinSelectionIndex())).title;
				String command="!root";
				Vector path=comm.buildSelectionPath(sel);
				for(int i=1; i<path.size(); i++)
					command+=" \""+path.get(i)+"\"";
				scriptsModel.addElement(new ScriptEntry(title,command));
			}
			new EditScriptGUI(scriptsModel,scriptsModel.getSize()-1,true);
		} else if(evt.getActionCommand().equals("editbookmark")) {
			for(int i=0; i<scriptsModel.getSize(); i++)
				if(scripts.isSelectedIndex(i))
					new EditScriptGUI(scriptsModel,i,false);
		} else if(evt.getActionCommand().equals("delbookmark")) {
			for(int i=0; i<scriptsModel.getSize(); i++)
				if(scripts.isSelectedIndex(i))
					scriptsModel.remove(i--);
		}
	}
	
	public void doubleClicked(JList list, int index) {
		if(list==menu) {
			//Vector items=(Vector)comm._menus.lastElement();
			//System.out.println(items.get(index)+" selected");
			comm.sendSelect();
			/*			int[] sel=menu.getSelectedIndices();
						if(sel.length==1) {
						comm.sendSelectionPath(comm.buildSelectionPath(sel[0]));
						} else if(sel.length>1) {
						Vector selectionPaths=new Vector();
						for(int i=0; i<sel.length; i++)
						selectionPaths.add(comm.buildSelectionPath(sel[i]));
						for(int i=0; i<selectionPaths.size(); i++)
						comm.sendSelectionPath((Vector)selectionPaths.get(i));
						}
			*/
			inputField.setText("");
		} else if(list==scripts) {
			for(int i=0; i<scriptsModel.getSize(); i++)
				if(scripts.isSelectedIndex(i))
					comm.sendInput(((ScriptEntry)scriptsModel.get(i)).cmd);
		} else {
			System.out.println("Unknown list double-clicked");
		}
	}
	
	public class ConstSizeJButton extends JButton {
		Dimension dim;
		ConstSizeJButton(String s, ImageIcon i, Dimension d) { super(s,i); dim=d; }
		public Dimension getPreferredSize() { return dim; }
		public Dimension getMinimumSize() { return dim; }
		public Dimension getMaximumSize() { return dim; }
		public Dimension getSize() { return dim; }
	}

	protected void init() {
		int spacer_size=10;
	
		
		setTitle("TekkotsuMon: Controller Menus");
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(Box.createHorizontalStrut(spacer_size),BorderLayout.WEST);
		getContentPane().add(Box.createHorizontalStrut(spacer_size),BorderLayout.EAST);
		getContentPane().add(Box.createVerticalStrut(spacer_size),BorderLayout.NORTH);
		getContentPane().add(Box.createVerticalStrut(spacer_size),BorderLayout.SOUTH);
		
		menu=new JList();
		menu.setCellRenderer(new MyCellRenderer());
		menu.setFixedCellWidth(165);
		menu.addMouseListener(new JListDoubleClick(this)); 
		menu.addListSelectionListener(new MySelectionListener(this));
		menu.addKeyListener(new ReturnFilter(this));
		
		JPanel content=new JPanel(new BorderLayout());
		Box titleBox=Box.createVerticalBox();
		title=new JLabel("-");
		title.setFont(new Font(title.getFont().getFontName(),Font.BOLD,title.getFont().getSize()));
		title.setAlignmentX(0);
		titleBox.add(title);
		titleBox.add(Box.createVerticalStrut(spacer_size));
		content.add(titleBox,BorderLayout.NORTH);
		
		Box menuBox=Box.createVerticalBox();
		menuScroll=new JScrollPane(menu);
		menuScroll.setAlignmentX(0.5f);
		menuBox.add(menuScroll);
		{
			Box tmp=Box.createHorizontalBox();
			backBut=new JButton("Back");
			Dimension dim=new Dimension(backBut.getPreferredSize().width+larrow.getIconWidth()+backBut.getIconTextGap(),backBut.getPreferredSize().height);
			tmp.add(backBut=new ConstSizeJButton("Back",larrow,dim));
			backBut.setEnabled(false);
			backBut.addActionListener(this);
			backBut.setToolTipText("Returns to previous control");
			tmp.add(refreshBut=new JButton("Refresh"));
			refreshBut.setEnabled(false);
			refreshBut.addActionListener(this);
			refreshBut.setToolTipText("Requests a menu refresh (handy if item names are dynamic)");
			tmp.setAlignmentX(0.5f);
			menuBox.add(tmp);
		}
		content.add(menuBox,BorderLayout.CENTER);

		Box statusbox=Box.createVerticalBox();
		statusbox.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			statusbox.add(sep);
		}
		statusbox.add(Box.createVerticalStrut(spacer_size-2));
		{
			JPanel tmp=new JPanel(new BorderLayout());
			status=new JLabel("Connecting...");
			tmp.add(status,BorderLayout.CENTER);
			{
				Box tmp2=Box.createHorizontalBox();
				estop=new EStopButton(new EStopListener(comm._host,EStopListener.defPort));
				estop.setMyDim(new Dimension(65,27));
				estop.setMargin(new Insets(0,0,0,0));
				tmp2.add(estop);
				tmp2.add(Box.createHorizontalStrut(spacer_size));
				reconnectBut=new JButton(carrows);
				reconnectBut.setPreferredSize(new Dimension(carrows.getIconWidth(),carrows.getIconHeight()));
				reconnectBut.addActionListener(this);
				reconnectBut.setToolTipText("Drop current connection and try again.");
				tmp2.add(reconnectBut);
				tmp.add(tmp2,BorderLayout.EAST);
			}
			statusbox.add(tmp);
		}
		content.add(statusbox, BorderLayout.SOUTH);
		
		Box p=Box.createVerticalBox();
		p.add(new JLabel("Send Input:"));
    inputFieldHistory=new Vector();
		for(int i=0; i<MAX_STORE_INPUT_HIST; i++)
			inputFieldHistory.add(prefs.get("inputFieldHistory"+i,""));
    inputFieldLocation=inputFieldHistory.size();
		p.add(inputField=new JTextField());
		inputField.setEnabled(false);
		inputField.addActionListener(this);
    inputField.addKeyListener(this);
		inputField.setPreferredSize(new Dimension(30,inputField.getPreferredSize().height));
		inputField.setToolTipText("Text from here is passed to selected controls, or the current control if no selection");

		p.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			sep.setMaximumSize(new Dimension(sep.getMaximumSize().width,spacer_size));
			p.add(sep);
		}
		p.add(Box.createVerticalStrut(spacer_size-2));
		
		{
			Box tmp=Box.createHorizontalBox();
			tmp.add(Box.createHorizontalGlue());
			JButton but;
		 	but=new JButton("Raw Cam");
			but.setToolTipText("Raw vision");
			but.addActionListener(this);
			but.setActionCommand("raw");
			tmp.add(but);
			but=new JButton("Seg. Cam");
			but.setToolTipText("Segmented vision");
			but.addActionListener(this);
			but.setActionCommand("rle");
			tmp.add(but);
			tmp.add(Box.createHorizontalGlue());
			tmp.setAlignmentX(0.0f);
			p.add(tmp);
		}
		
		p.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			sep.setMaximumSize(new Dimension(sep.getMaximumSize().width,spacer_size));
			p.add(sep);
		}
		p.add(Box.createVerticalStrut(spacer_size-2));
		
		p.add(new JLabel("Scripts:"));
		scripts=new JList();
		scripts.setFixedCellWidth(165);
		scripts.addMouseListener(new JListDoubleClick(this));
		scripts.addKeyListener(new ReturnFilter(this));
		scripts.addKeyListener(new DelFilter(this));
		scripts.setModel(scriptsModel);
		{
			JScrollPane tmp=new JScrollPane(scripts);
			tmp.setAlignmentX(0);
			p.add(tmp);
		}

		{
			Box bbox=Box.createHorizontalBox();
			bbox.setAlignmentX(0);
			bbox.add(Box.createHorizontalGlue());
			JButton tmp;
			bbox.add(tmp=new JButton("Add"));
			tmp.setActionCommand("addbookmark");
			tmp.addActionListener(this);
			tmp.setToolTipText("Adds a shortcut to the current item; saved when window closed");
			bbox.add(tmp=new JButton("Edit"));
			new AutoDisableListener(tmp,scripts);
			tmp.setActionCommand("editbookmark");
			tmp.addActionListener(this);
			tmp.setToolTipText("Allows you to edit a script");
			bbox.add(Box.createHorizontalGlue());
			p.add(bbox);
		}

		{
			JPanel p2=new JPanel(new BorderLayout());
			p2.add(p,BorderLayout.EAST);
			p2.add(Box.createHorizontalStrut(spacer_size),BorderLayout.WEST);
			content.add(p2, BorderLayout.EAST);
		}
		
		getContentPane().add(content,BorderLayout.CENTER);
		EscFilter esc=new EscFilter(backBut);
		addKeyListener(esc);
		inputField.addKeyListener(esc);
		menu.addKeyListener(esc);
		
		addWindowListener(new CloseVisionAdapter(this));

		setLocation(prefs.getInt("ControllerGUI.location.x",50),prefs.getInt("ControllerGUI.location.y",50));
		int numScripts=prefs.getInt("ControllerGUI.numScripts",0);
		for(int i=0; i<numScripts; i++)
			scriptsModel.addElement(new ScriptEntry(prefs.get("ControllerGUI.script"+i+".title","unknown"),prefs.get("ControllerGUI.script"+i+".cmd","")));

		pack();
		show();
		getRootPane().setMinimumSize(getRootPane().getSize());
	}

	class CloseVisionAdapter extends WindowAdapter {
		ControllerGUI gui;
		CloseVisionAdapter(ControllerGUI gui) {this.gui=gui;}
		public void windowClosing(WindowEvent e) {
			prefs.putInt("ControllerGUI.location.x",getLocation().x+getInsets().left);
			prefs.putInt("ControllerGUI.location.y",getLocation().y+getInsets().top);
			prefs.putInt("ControllerGUI.numScripts",scriptsModel.getSize());
			for(int i=0; i<scriptsModel.getSize(); i++) {
				prefs.put("ControllerGUI.script"+i+".title",((ScriptEntry)scriptsModel.get(i)).title);
				prefs.put("ControllerGUI.script"+i+".cmd",((ScriptEntry)scriptsModel.get(i)).cmd);
			}
			for(int i=0; i<MAX_STORE_INPUT_HIST; i++)
				prefs.put("inputFieldHistory"+i,(String)inputFieldHistory.get(inputFieldHistory.size()-MAX_STORE_INPUT_HIST+i));
			gui.comm.kill();
			estop.close();
			while(gui.comm.isConnected())
				try { Thread.sleep(50); System.out.print("."); } catch(Exception ex) {}
		}
	}

	public void show() {
		super.show();
		menu.requestFocus();
	}
	
	public static void main(String s[]) throws java.lang.InterruptedException {
    if (s.length>1) {
      System.out.println("usage: java ControllerGUI [host]");
      System.exit(1);
    }

    try {
      DogConfig dogConfig=new DogConfig (s);
      ControllerGUI controllerGUI=new ControllerGUI(dogConfig.getIP(),
          Integer.parseInt(dogConfig.getValue("Controller", "gui_port")));

      controllerGUI.addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) { System.exit(0);} });
			try{
				DogConfigFTP dog_ftp=new DogConfigFTP(dogConfig.getIP(), 21, "config", "config");
				String col=dogConfig.getValue("Vision","colors");
				col=col.substring(col.lastIndexOf('/')+1);
				PrintWriter out=new PrintWriter(new FileWriter("default.col"));
				String tmp=dog_ftp.getFile(col);
				out.print(tmp);
				out.close();
			} catch(Exception ex) { ex.printStackTrace(); }
    } catch (IllegalArgumentException ex) {System.exit(0);}
	}

  public void keyPressed(KeyEvent e) {
    if (e.getComponent()==inputField) {
      int key=e.getKeyCode();
      if (key==KeyEvent.VK_UP || key==KeyEvent.VK_KP_UP) {
        inputFieldLocation--;
        if (inputFieldLocation < 0)
          inputFieldLocation+=inputFieldHistory.size();
        inputField.setText((String)inputFieldHistory.get(inputFieldLocation));
      } else if (key==KeyEvent.VK_DOWN || key==KeyEvent.VK_KP_DOWN) {
        inputFieldLocation++;
        if (inputFieldLocation >= inputFieldHistory.size())
          inputFieldLocation-=inputFieldHistory.size();
        inputField.setText((String)inputFieldHistory.get(inputFieldLocation));
      }
    }
  }
  public void keyReleased(KeyEvent e) { }
  public void keyTyped(KeyEvent e) { }
}

