function plotlog(logfilein)
     global logfile info jpl plotops legh ploth subp timeslider window aibopos jgraph pgraph posgraph bodyangle updatego legpos legspos;
     updatego=0;
     ploth=[];
     subp=[];
     if(isempty(plotops))
       plotops=struct('drawbuttons',1);
     end
     logfile=logfilein;
  ers2xxinfo;
bodyangle=.20944;
samplecount=size(logfile,1);
aibopos=zeros(4,3,samplecount);
legpos=zeros(4,3,samplecount);
  jpl=info.JointsPerLeg; %because it's used so much...
  if(size(jgraph)<1)
     jgraph=gcf;
  end
  if(size(pgraph)<1)
    pgraph=figure;
  end
  if(size(posgraph)<1)
    posgraph=figure;
  end;
  set(jgraph,'Name','Joint positions');
  set(pgraph,'Name','Aibo Feet Accumulator');
  set(posgraph,'Name','Foot trajectory');
  figure(jgraph);

clf;

  window=struct('size',logfile(end,1)-logfile(1,1),'start',logfile(1,1),'zoomfactor',1);

  timeslider=uicontrol('style','slider','position',[100,0,100,20],'callback','setslide;');
  zoomin=uicontrol('style','pushbutton','position',[250,0,50,20],'string','Zoom in','callback','zoomin;');
  zoomout=uicontrol('style','pushbutton','position',[350,0,50,20],'string','Zoom out','callback','zoomout;');

  for leg=1:4
    plotleg(leg,getJointAngles(leg),getDuties(leg),getButton(leg));
  end

  legh=legend(info.legJointOrder{:},0);
  posnow=get(legh,'position');
  posnow(1:2)=[0 0];
  set(legh,'position',posnow);
  
  %%%%basic stuff done

figure(pgraph);
clf;
plotpath;
figure(posgraph);
clf;
plotpos;
%fit graph

updatego=1;
updateAxes; %really just fix slider

function plotleg(leg,position,duties,button)
  global logfile info jpl ploth subp plotops window defax hb aibopos pgraph jgraph legpos;
ontime=extractButtonOn(button);
  subp(end+1)=subplot(2,4,leg);
  hb=plot(logfile(:,1),position)';
  title([info.legOrder{leg} ' pos']);
  if(plotops.drawbuttons~=0)
    hold on
    hb=[hb plot(logfile(ontime,1),position(ontime,:),'o')'];
plot(logfile(:,1),button,':k');
  end
  ploth=[ploth hb];
  subp(end+1)=subplot(2,4,leg+4);
  hb=plot(logfile(:,1),duties)';
  title([info.legOrder{leg}, ' duties']);
  if(plotops.drawbuttons~=0)
    hold on
    hb=[hb plot(logfile(ontime,1),duties(ontime,:),'o')'];
  end
  ploth=[ploth hb];
  defax=axis;

  %forward kinematics tracking:
  for step=1:length(button)
    legPoint(step,leg); %precalc legpositions
  end
  altbutton=getButton(mod(leg+2,4)+1);
  for step=2:(length(button))
%    if(button(step)>0 | altbutton(step)>0) %counts feet as "down" if either front or back is on. this turns out to be bad
    if(button(step)>0)
      delta=legpos(leg,:,step)-legpos(leg,:,step-1);
    else
      delta=[0 0 0];
    end
    aibopos(leg,:,step)=aibopos(leg,:,step-1)-delta; %%aibo moves opposite of foot push
  end

%aibopos=legpos; %%% testing hack!

function pos=getJointAngles(leg)
     global logfile info jpl;
leg=leg-1;
    pos=logfile(:,info.LogOffset.positions+leg*jpl:1:info.LogOffset.positions+((leg+1)*jpl-1));

function duties=getDuties(leg)
     global logfile info jpl;
leg=leg-1;
  duties=logfile(:,(leg*jpl+info.LogOffset.duties):1:((leg+1)*jpl+info.LogOffset.duties-1));
     
function buttons=getButton(leg)
     global logfile info jpl;
leg=leg-1;
  buttons=logfile(:,info.LogOffset.buttons+leg);

function onidx=extractButtonOn(button)
   onidx=find(button>0);

function onidx=findButtonOn(leg)
   global logfile info jpl;
   button=getButton(leg);
   onidx=find(button>0);

%%%%%%%%%%%%%
%% gui stuff
%%%%%%%%%%%%%



%%%%%%%%%
%% Forward kinematics stuff
%%%%%%%%%

function R=rotate(x,y,z,theta)
  c=cos(theta);
  s=sin(theta);
  t=1-cos(theta);
  R=[t*x^2+c, t*x*y-s*z, t*x*z+s*y, 0; ...
     t*x*y+s*z, t*y^2+c, t*y*z-s*x, 0; ...
     t*x*z-s*y, t*y*z+s*x, t*z^2+c, 0; ...
     0, 0, 0, 1 ];

function T=translate(t)
  x=t(1);
 y=t(2);
z=t(3);
  T=[1, 0, 0, x ; ...
     0, 1, 0, y ; ...
     0, 0, 1, z ; ...
     0, 0, 0, 1 ];

function dpt=diffPoints(t1,t2,leg)
  global logfile info jpl legpos;
  pos=getJointAngles(leg);
  buttons=getButton(leg);

  limblen=info.limblen(leg,:,:);
  pos1=pos(t1,:);
  pos2=pos(t2,:);
  pt=[0 0 0 1]; %homogenous point baby
  M=eye(4);
% my coordinate system: y+ = forward, x+ = right, z+ = up
  M=M*translate( -limblen(:,:,1) ); %initial position separated from body
  M=M*rotate(1,0,0,pos1(1)); %rotator - around x 
  M=M*rotate(0,1,0,pos1(2)); %elevator - around y
  M=M*translate( -limblen(:,:,2) );
  M=M*rotate(1,0,0,pos1(3)); %knee - around x
  M=M*translate( -limblen(:,:,3) );
  groundpt1=M*pt';

%	   legpos(leg,:,t1)=groundpt1(1:3);

  M=eye(4);
  M=M*translate( -limblen(:,:,1) ); %initial position separated from body
  M=M*rotate(1,0,0,pos1(1)); %rotator - around x 
  M=M*rotate(0,1,0,pos1(2)); %elevator - around y
  M=M*translate( -limblen(:,:,2) );
  M=M*rotate(1,0,0,pos1(3)); %knee - around x
  M=M*translate( -limblen(:,:,3) );
  groundpt2=M*pt';

%	   legpos(leg,:,t1)=groundpt2(1:3);

%  if(buttons(t1)<1) % foot starting in air
%    dpt=[0,0,0]; %no movement
%    return; 
%else
  dpt=groundpt1-groundpt2;
%end

;  toerotateX=(pos1(3)-pos1(1))-(pos2(3)-pos2(1));
;	   toerotateY=(pos1(2)-pos2(2));
;  M=M*rotate(1,0,0,toerotateX); %assuming shoulder stays even height, and flat ground, parallel lines are your friend. this is basically change in toe-tilt
;%  M=M*rotate(0,1,0,toerotateY);
;  M=M*translate( limblen(:,:,3) );
;  M=M*rotate(1,0,0,pos2(3)); %knee - around x
;  M=M*translate( limblen(:,:,2) );
;  M=M*rotate(0,1,0,pos2(2)); %elevator - around y
;  M=M*rotate(1,0,0,pos2(1)); %rotator - around x 
;  M=M*translate( limblen(:,:,1) );
;  bodypt2=M*pt';
;  dpt=bodypt2(1:3)';


function footpoint=legPoint(t1,leg)
global logfile info jpl legpos;
pos=getJointAngles(leg);
buttons=getButton(leg);

limblen=info.limblen(leg,:,:);
pos1=pos(t1,:);
pt=[0 0 0 1]; %homogenous point baby
M=eye(4);
if(leg>2) %if it's a back foot
      pos1(1)=-pos1(1); %flip it's y rotation
      pos1(3)=-pos1(3); %flip it's y rotation
end
% my coordinate system: x+ = forward, y+ = right, z+ = up
M=M*translate( limblen(:,1,:) ); %initial position separated from body
M=M*rotate(0,1,0,-pos1(1)); %rotator - around y (but +pos(1) means back on dog)
if(mod(leg,2)==0) %if it's a right foot...
      pos1(2)=-pos1(2); %flip it's x rotation
end
M=M*rotate(1,0,0,pos1(2)); %elevator - around x
M=M*translate( limblen(:,2,:) );
M=M*rotate(0,1,0,-pos1(3)); %knee - around y
M=M*translate( limblen(:,3,:) );
footpoint=M*pt';
footpoint(2)=-footpoint(2); %flip the y data for our sanity...
    legpos(leg,:,t1)=footpoint(1:3);
return;
