package org.tekkotsu.mon;

import java.util.Vector;
import javax.swing.JPanel;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;

public class SketchPanel extends JPanel {
    String host;
    int port;
    BufferedImage _image;
    boolean lockAspect=true;
    Vector sketches;
    static int width = 176;
    static int height = 144;
    float tgtAspect = 176/(float)144;

    protected SketchPanel(String host, int port) {
	this.host = host;
	this.port = port;
	setBackground(Color.BLACK);
	setForeground(Color.WHITE);
	setOpaque(!lockAspect);
	_image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

	// Create a blank frame:
	update(new Vector());
    }

    public BufferedImage getImage() {
	return _image;
    }

    // Takes in a Vector of int arrays of pixels to composite:
    public void update(Vector sketches) {
	int [] data = new int[width*height];

	// Get new Sketchs and compose them:
	this.sketches = sketches;
	for(int i = 0; i < sketches.size(); i++) {
	    
	}
	_image.setRGB(0,0,width,height,data,0,width);
    }

    public void paint(Graphics graphics) {
	super.paint(graphics);
	Dimension sz=getSize();

	float curasp=sz.width/(float)sz.height;
	if(curasp>tgtAspect) {
	    int width=(int)(sz.height*tgtAspect);
	    drawImage(graphics,_image, (sz.width-width)/2, 0, width, sz.height);
	} else if(curasp<tgtAspect) {
	    int height=(int)(sz.width/tgtAspect);
	    drawImage(graphics,_image, 0, (sz.height-height)/2, sz.width, height);
	} else {
	    drawImage(graphics,_image, 0, 0, sz.width, sz.height);
	}
    }
    
    protected void drawImage(Graphics g, BufferedImage img, int x, int y, int w, int h) {
	if(img!=null)
	     g.drawImage(img,x,y,w,h,null);
	else {
	    g.setColor(getBackground());
	    g.fillRect(x,y,w,h);
	    FontMetrics tmp=g.getFontMetrics();
	    String msg="No image";
	    int strw=tmp.stringWidth(msg);
	    int strh=tmp.getHeight();
	    g.setColor(getForeground());
	    g.drawString(msg,(getSize().width-strw)/2,(getSize().height-strh)/2+tmp.getAscent());
	}
    }
}
