package org.tekkotsu.mon;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.lang.String;
//import java.util.LinkedList;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Date;
import java.util.Vector;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import java.io.File;
import java.net.*;
import java.io.*;
import java.util.StringTokenizer;

public class SketchGUI extends JFrame implements ActionListener,TreeSelectionListener {
    VisionPanel sketch;
    JButton spawnBut;
    JButton refreshBut;
    JButton saveImageBut;
	JButton refreshListBut;
    JTree sketchTree;
	DefaultMutableTreeNode root= new DefaultMutableTreeNode("camspace");
    JLabel status;
    float mspf=0;
    float mspfGamma=.9f;
    String state="";
    String host;
    int port;
    static int defSketchPort = 5873; // Default Port
    static int defListPort = 5874; // Default Port
    static Preferences prefs = Preferences.userNodeForPackage(SketchGUI.class);
	// the socket over which listings are retrieved and Sketch commands are sent
	Socket listingSocket=null;
	PrintWriter netout = null; // network output
    BufferedReader netin = null; // network input

    public static void main(String args[]) {
	if(args.length<1)
	     usage();

	int port = defListPort;
	if(args.length>1)
	     port=Integer.parseInt(args[1]);

	SketchGUI gui = new SketchGUI(args[0],port);
	gui.addWindowListener(new WindowAdapter() {
		 public void windowClosing(WindowEvent e) {}});
	gui.show();
    }
		
    public static void usage() {
	System.out.println("Usage: java SketchGUI host [port]");
	System.out.println("       if port is not specified, it defaults to: [12345]"); // Default port
	System.exit(2);
    }
			
    public void actionPerformed(ActionEvent e) {
	if(e.getActionCommand().compareTo("spawn")==0) {
	    SketchGUI gui = new SketchGUI(host,port);
	    gui.addWindowListener(new WindowAdapter() {
		     public void windowClosing(WindowEvent e) {
//			 System.exit(0);
		     }});
	    gui.show();
	} else if(e.getActionCommand().compareTo("refresh")==0) {
	    // Refresh the sketch tree list:
	    
	    // Refresh the sketch based on which are checked:
//	    Vector sketches = new Vector();
//	    sketch.update(sketches);
	} else if(e.getActionCommand().compareTo("saveimg")==0) {
	    File cursavepath = new File(prefs.get("cursavepath",""));
	    JFileChooser dia=new JFileChooser(cursavepath);
	    dia.setDialogTitle("Save Image...");
	    Component cur=this;
	    while(cur.getParent()!=null)
		 cur=cur.getParent();
	    if(dia.showSaveDialog(cur)==JFileChooser.APPROVE_OPTION) {
		prefs.put("cursavepath",dia.getCurrentDirectory().getPath());
		String base=dia.getSelectedFile().getName();
		String format;
		if(base.lastIndexOf('.')==-1) {
		    format="png";
		} else {
		    int i=base.lastIndexOf(".");
		    format=base.substring(i+1);
		    base=base.substring(0,i);
		}
		try {
			FileOutputStream fileout=new FileOutputStream(dia.getSelectedFile().getParent()+File.separator+base+"."+format);
			ImageIO.write(sketch.getListener().getImage(),format,fileout);
		} catch(Exception ex) {}
	    }
	} else if(e.getActionCommand().compareTo("refreshlist")==0) {
		// send command to refresh the sketch tree list
		netout.println("list");
//		DefaultMutableTreeNode root = new DefaultMutableTreeNode("camspace");
		root.removeAllChildren();
		// read in new sketch listing
		try {
			String inputLine;
			System.out.println(inputLine = netin.readLine());
			while((inputLine=netin.readLine()).compareTo("list end") != 0) {
				// parse name
				StringTokenizer st = new StringTokenizer(inputLine,": ");
				st.nextToken();
				String name = st.nextToken();

				// parse id
				inputLine = netin.readLine();
				st = new StringTokenizer(inputLine,": ");
				st.nextToken();
				int id = Integer.parseInt(st.nextToken());
				
				//parse parentId
				inputLine = netin.readLine();
				st = new StringTokenizer(inputLine,": ");
				st.nextToken();
				int parentId = Integer.parseInt(st.nextToken());
			
				// add node
				System.out.println("id:"+id+"parentId:"+parentId+"name:"+name);
				DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(new SketchInfo(id, parentId, name));
				root.add(newnode);
			}
			System.out.println(inputLine);
			//sketchTree = new JTree(root); // is this right?
			//JScrollPane treeView = new JScrollPane(sketchTree);
//			sketchTree.removeAll();
//			sketchTree.add(root);
			sketchTree.updateUI();
		} catch(IOException ioe) {
			System.err.println("Transfer error");
		}
	}
    }

    public SketchGUI(String host, int port) {
	super();
	this.host = host;
	this.port = port;

	// network setup
	try {
		System.out.println("Trying to open socket...");
		listingSocket = new Socket(host,port);
		netout = new PrintWriter(listingSocket.getOutputStream(), true);
  		netin = new BufferedReader(new InputStreamReader(
					listingSocket.getInputStream()));
	} catch (UnknownHostException e) {
		System.err.println("Don't know about host:"+host);
		System.exit(1);
	} catch (IOException e) {
		System.err.println("Couldn't get I/O for "
				+ "the connection to:" + host + ".");
		System.exit(1);
	}

	init();
    }


    public void init() {
	int strutsize=10;
	int sepsize=5;
	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(Box.createVerticalStrut(strutsize),BorderLayout.NORTH);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.WEST);
	getContentPane().add(Box.createHorizontalStrut(strutsize),BorderLayout.EAST);
		
	setTitle("TekkotsuMon: Sketch");
	sketch=new VisionPanel(new VisionListener(host, defSketchPort));
	
	sketch.setMinimumSize(new Dimension(VisionListener.DEFAULT_WIDTH/2, VisionListener.DEFAULT_HEIGHT/2));
	sketch.setPreferredSize(new Dimension(VisionListener.DEFAULT_WIDTH*2, VisionListener.DEFAULT_HEIGHT*2));
	sketch.setLockAspectRatio(true);
	getContentPane().add(sketch,BorderLayout.CENTER);

	{
	    Box tmp1 = Box.createHorizontalBox();
	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    {
		Box tmp2 = Box.createVerticalBox();

		tmp2.add(Box.createVerticalStrut(strutsize));

		{
		    Box tmp3 = Box.createHorizontalBox();
		    tmp3.add(status=new JLabel(state));
		    tmp3.add(Box.createHorizontalGlue());

		    spawnBut = new JButton("Spawn New");
		    spawnBut.setAlignmentX(0.5f);
		    spawnBut.addActionListener(this);
		    spawnBut.setActionCommand("spawn");
		    spawnBut.setEnabled(true);
		    spawnBut.setToolTipText("Spawns a new sketch monitor;");
		    tmp3.add(spawnBut);

		    tmp3.add(Box.createHorizontalStrut(strutsize));
		
		    refreshBut = new JButton("Refresh Image");
		    refreshBut.setAlignmentX(0.5f);
		    refreshBut.addActionListener(this);
		    refreshBut.setActionCommand("refresh");
		    refreshBut.setEnabled(true);
		    refreshBut.setToolTipText("Refreshes the displayed sketch;");
		    tmp3.add(refreshBut);

		    tmp3.add(Box.createHorizontalStrut(strutsize));
		    
		    saveImageBut = new JButton("Save Image");
		    saveImageBut.setAlignmentX(0.5f);
		    saveImageBut.addActionListener(this);
		    saveImageBut.setActionCommand("saveimg");
		    saveImageBut.setEnabled(true);
		    saveImageBut.setToolTipText("Saves sketch to a file - use .jpg or .png extension to choose format;");
		    tmp3.add(saveImageBut);
			tmp3.add(Box.createHorizontalStrut(strutsize));


			refreshListBut = new JButton("Refresh Listing");
			refreshListBut.setAlignmentX(0.5f);
			refreshListBut.addActionListener(this);
			refreshListBut.setActionCommand("refreshlist");
			refreshListBut.setEnabled(true);
			refreshListBut.setToolTipText("Refreshes the sketch listing;");
			tmp3.add(refreshListBut);
		    tmp2.add(tmp3, BorderLayout.CENTER);
		}

		tmp2.add(Box.createVerticalStrut(strutsize));
		// Sketch Tree:
		sketchTree = new JTree(new DefaultTreeModel(initSketchTree(host, port)));
		tmp2.add(new JScrollPane(sketchTree));
		// set up sketch node selection
		sketchTree.getSelectionModel().setSelectionMode
		            (TreeSelectionModel.SINGLE_TREE_SELECTION);
		//Listen for when the selection changes.
	    sketchTree.addTreeSelectionListener(this);

//		JFrame sketchFrame = new JFrame("Sketches");
//		sketchFrame.setSize(200,400);
//		sketchFrame.getContentPane().add(new JScrollPane(sketchTree));
//		JScrollPane sketchPane = new JScrollPane(sketchTree);
//		sketchPane.setSize(200,100);
//		tmp2.add(sketchPane);
		tmp2.add(Box.createVerticalStrut(strutsize));
		tmp2.add(new JSeparator());
		tmp2.add(Box.createVerticalStrut(strutsize-sepsize));
		{
		    Box tmp4 = Box.createHorizontalBox();
		    tmp4.add(status=new JLabel(state));
		    tmp4.add(Box.createHorizontalGlue());
		    tmp2.add(tmp4);
		}
		tmp2.add(Box.createVerticalStrut(strutsize));
		tmp1.add(tmp2);
	    }
	    tmp1.add(Box.createHorizontalStrut(strutsize));
	    getContentPane().add(tmp1,BorderLayout.SOUTH);
	}
	pack();
	
	String name="SketchGUI"+".location";
	setLocation(prefs.getInt(name+".x",50),prefs.getInt(name+".y",50));
    }

    public TreeNode initSketchTree(String host, int port) {
//	MutableTreeNode root = new DefaultMutableTreeNode("camspace");

	// Just for demonstration:
	DefaultMutableTreeNode cam = new DefaultMutableTreeNode("cam");
	DefaultMutableTreeNode pmask = new DefaultMutableTreeNode("pmask");
	DefaultMutableTreeNode filled = new DefaultMutableTreeNode("filled");
	DefaultMutableTreeNode skel = new DefaultMutableTreeNode("skel");
	DefaultMutableTreeNode all_lines = new DefaultMutableTreeNode("all_lines");
	DefaultMutableTreeNode b_ellipse_render = new DefaultMutableTreeNode("b_ellipse_render");
	root.insert(cam,0);
	cam.insert(pmask,0);
	pmask.insert(filled,0);
	filled.insert(skel,0);
	skel.insert(all_lines,0);
	cam.insert(b_ellipse_render,1);
//	for(int i = 0; i < 5; i++)
//	     root.insert(new DefaultMutableTreeNode("Sketch("+i+")"), i);

	return root;
    }

	// gets called when a Sketch selection is clicked
	public void valueChanged(TreeSelectionEvent e) {
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)
			sketchTree.getLastSelectedPathComponent();

		if (node == null) return;

		Object nodeInfo = node.getUserObject();
		if (node.isLeaf()) {
			SketchInfo sinfo = (SketchInfo)nodeInfo;
			System.out.println("id clicked:"+sinfo.id);
			netout.println("get "+sinfo.id);
			try {
				String inputLine;
				while((inputLine=netin.readLine()).compareTo("get end") != 0) {
					System.out.println(inputLine);
				}
			} catch (IOException ioe) {
			System.err.println("Transfer error");
			}
		} else {
			//displayURL(helpURL); 
		}
	}
}
