package org.tekkotsu.mon;

import java.io.InputStream;
import java.net.Socket;
import javax.swing.JFrame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Date;

public class VisionRawListener extends VisionListener {
	int channels=3;
	static int width=176;
	static int height=144;
	int pktSize=width*height*channels;
  int oldformat=PACKET_VISIONRAW_FULL;
  int format;

	byte[] _data=new byte[pktSize];
	byte[] _outd=new byte[pktSize];
	int[] _pixels=new int[width*height];;
	BufferedImage img=new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
	int bytesRead;
	boolean convertRGB=true;
	static int defPort=10011;

  Object packetFormatChangeLock=new Object();;

	public void connected(Socket socket) {
		_isConnected=true;
		fireVisionUpdate();
		try {
			InputStream in=socket.getInputStream();
			_isConnected=true;
			while (true) {
        format=readInt(in);
        int timest=readInt(in);

        if (format!=oldformat) {
          synchronized (packetFormatChangeLock) {
            switch (format) {
              case PACKET_VISIONRAW_HALF:
                width=88;
                height=72;
                channels=3;
                pktSize=88*72*3;
                break;
              case PACKET_VISIONRAW_FULL:
                width=176;
                height=144;
                channels=3;
                pktSize=176*144*3;
                break;
              case PACKET_VISIONRAW_YFULL_UVHALF:
                width=176;
                height=144;
                channels=3;
                pktSize=(176*144*3)/2;
                break;
              default:
                System.err.println("VisionRawListener: unknown packet type");
                throw new java.lang.NoSuchFieldException("fake exception");
            }

            _data=new byte[pktSize];
            _outd=new byte[pktSize];
            _pixels=new int[width*height];;
            img=new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
            oldformat=format;
          }
        }

				int br;
				bytesRead=0;

				while(bytesRead<pktSize) {
					br=in.read(_data,bytesRead,(pktSize-bytesRead>1024)?1024:(pktSize-bytesRead));
					bytesRead=bytesRead+br;
				}
				synchronized(_outd) {
					byte[] temp=_data;
					_data=_outd;
					_outd=temp;
					timestamp=new Date();
				}
				fireVisionUpdate();
			}
		} catch (Exception ex) { }
		
		try { socket.close(); } catch (Exception ex) { }
		_isConnected=false;
		fireVisionUpdate();
	}
	
	public byte[] getData() {
//		frameTimer();
		synchronized (_outd) {
			updatedFlag=false;
			return _outd;
		}
	}

	public void setConvertRGB(boolean b) { 
		if(b!=convertRGB) {
			convertRGB=b;
			updatedFlag=true;
			for(int i=0; i<listeners.size(); i++)
				((VisionUpdatedListener)listeners.get(i)).visionUpdated(this);
		}
	}
	public boolean getConvertRGB() { return convertRGB; }

	public int[] getYUVPixels() {
		synchronized(packetFormatChangeLock) {
			byte[] data=getData();
      if (format==PACKET_VISIONRAW_HALF || format==PACKET_VISIONRAW_FULL) {
        int offset=0;
        for (int i=0; i<width*height; i++) {
          int y=(int)data[offset++]&0xFF;
          int u=(int)data[offset++]&0xFF;
          int v=(int)data[offset++]&0xFF;
          _pixels[i]=(255<<24) | (y<<16) | (u<<8) | v;
        }
      } else if (format==PACKET_VISIONRAW_YFULL_UVHALF) {
        int i_offset=0, o_offset=0;
        for (int y=0; y<height; y+=2) {
          for (int x=0; x<width; x+=2) {
            int y1=(int)data[i_offset++]&0xFF;
            int u=(int)data[i_offset++]&0xFF;
            int v=(int)data[i_offset++]&0xFF;
            int y2=(int)data[i_offset++]&0xFF;
            _pixels[o_offset]=(255<<24) | (y1<<16) | (u<<8) | v;
            _pixels[o_offset+width]=(255<<24) | (u<<8) | v;
            o_offset++;
            _pixels[o_offset]=(255<<24) | (y2<<16) | (u<<8) | v;
            _pixels[o_offset+width]=(255<<24) | (u<<8) | v;
            o_offset++;
          }
          for (int x=0; x<width; x++) {
            int y1=(int)data[i_offset++]&0xFF;
            _pixels[o_offset++]|=y1<<16;
          }
        }
      }
		}
		return _pixels;
	}

	public int[] getRGBPixels() {
		synchronized(packetFormatChangeLock) {
			byte[] data=getData();
      if (format==PACKET_VISIONRAW_HALF || format==PACKET_VISIONRAW_FULL) {
        int offset=0;
        for (int i=0; i<width*height; i++) {
          int y=(int)data[offset++]&0xFF;
          int u=(int)data[offset++]&0xFF;
          int v=(int)data[offset++]&0xFF;
          _pixels[i]=pixelYUV2RGB(y, u, v);
        }
      } else if (format==PACKET_VISIONRAW_YFULL_UVHALF) {
        int i_offset=0, o_offset=0;
        for (int y=0; y<height; y+=2) {
          for (int x=0; x<width; x+=2) {
            int y1=(int)data[i_offset++]&0xFF;
            int u=(int)data[i_offset++]&0xFF;
            int v=(int)data[i_offset++]&0xFF;
            int y2=(int)data[i_offset++]&0xFF;
            _pixels[o_offset]=pixelYUV2RGB(y1, u, v);
            _pixels[o_offset+width]=(255<<24) | (u<<8) | v;
            o_offset++;
            _pixels[o_offset]=pixelYUV2RGB(y1, u, v);
            _pixels[o_offset+width]=(255<<24) | (u<<8) | v;
            o_offset++;
          }
          for (int x=0; x<width; x++) {
            int y1=(int)data[i_offset++]&0xFF;
            _pixels[o_offset]|=y1<<16;
            _pixels[o_offset]=pixelYUV2RGB(_pixels[o_offset]);
            o_offset++;
          }
        }
      }
		}
		return _pixels;
	}

  static final int pixelYUV2RGB(int y, int u, int v) {
    u=u*2-255;
    v=v*2-255;
    int r=y+u;
    int b=y+v;
    u=u>>1;
    v=(v>>2)-(v>>4);
    int g=y-u-v;
    if (r<0) r=0; if (g<0) g=0; if (b<0) b=0;
    if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;

    return (255<<24) | (r<<16) | (g<<8) | b;
  }

  static final int pixelYUV2RGB(int yuv) {
    int y=(yuv>>16)&0xff;
    int u=(yuv>>8)&0xff;
    int v=yuv&0xff;
    u=u*2-255;
    v=v*2-255;
    int r=y+u;
    int b=y+v;
    u=u>>1;
    v=(v>>2)-(v>>4);
    int g=y-u-v;
    if (r<0) r=0; if (g<0) g=0; if (b<0) b=0;
    if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;

    return (255<<24) | (r<<16) | (g<<8) | b;
  }

	public BufferedImage getImage() {
		int[] data=getConvertRGB()?getRGBPixels():getYUVPixels();
		img.setRGB(0,0,width,height,data,0,width);
		return img;
	}
	
	public VisionRawListener() { super(); }
	public VisionRawListener(int port) { super(port); }
	public VisionRawListener(String host, int port) { super(host,port); }
}
