import java.io.InputStream;
import java.net.Socket;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.awt.image.BufferedImage;
import java.util.Date;

public class VisionRleListener extends VisionListener {
	static int width=176;
	static int height=144;
	byte[] _data=new byte[22*height*3*2];
	byte[] _outd=new byte[width*height];
	static int defPort=10012;
	static final boolean _debug=false;

	//todo: read this from the same file the dog is using
	static final byte cmap[]={ (byte)  0, (byte)  0, (byte)  0,
	                           (byte)  0, (byte)  0, (byte)  0,
	                           (byte)  0, (byte)128, (byte)255,
	                           (byte)  0, (byte)128, (byte)  0,
	                           (byte)255, (byte)128, (byte)  0,
	                           (byte)  0, (byte)255, (byte)  0,
	                           (byte)128, (byte)  0, (byte)255,
	                           (byte)255, (byte)  0, (byte)  0,
	                           (byte)255, (byte)128, (byte)228,
	                           (byte)255, (byte)255, (byte)  0,
	                           (byte)200, (byte)200, (byte)228,
	                           (byte)200, (byte)100, (byte)  0  };
	IndexColorModel _cmodel=new IndexColorModel(7, 12, cmap, 0, false);
	BufferedImage img=new BufferedImage(width,height,BufferedImage.TYPE_BYTE_INDEXED,_cmodel);


	void connected(Socket socket) {
		_isConnected=true;
		fireVisionUpdate();
		try {
			InputStream in=socket.getInputStream();
			while (true) {
				int size=readInt(in);
				if(!_isConnected) break;
				size=size*3;
				readBytes(_data, in, size);
				if(!_isConnected) break;
				timestamp=new Date();
				decodeRLE(size);
				fireVisionUpdate();
			}
		} catch (Exception ex) { }

		try { socket.close(); } catch (Exception ex) { }
		_isConnected=false;
		fireVisionUpdate();
	}

	void decodeRLE(int pktSize) {
		int curx=0, cury=0;
		int dlength=pktSize;
		int dpos=0;

		synchronized (_outd) {
			for (; dlength>=3 && cury<height;) {
				byte color;
				color=_data[dpos++];
				color++;
				int x=b2i(_data[dpos++]);
				int len=b2i(_data[dpos++]);
				dlength-=3;
				if (x < curx) {
					if (_debug) System.out.println("backwards x movement");
					break;
				}

				for (; curx < x; curx++)
					_outd[cury*width+curx]=1;

				if (curx+len>width) {
					if (_debug) System.out.println("run past end");
					break;
				}

				for (; len>0; len--, curx++)
					_outd [cury*width+curx]=color;
				if (curx==width) {
					cury++;
					curx=0;
				}
			}
		}
		if (cury!=height) {
			if (_debug) System.out.println("early end of data\n");
		}
	}

	public byte[] getData() {
//		frameTimer();
		synchronized (_outd) {
			updatedFlag=false;
			return _outd;
		}
	}

	public BufferedImage getImage() {
		synchronized (_outd) {
			byte[] data=getData();
			img.getRaster().setDataElements(0,0,width,height,data);
		}
		return img;
	}

	public VisionRleListener() { super(); }
	public VisionRleListener(int port) { super(port); }
	public VisionRleListener(String host, int port) { super(host,port); }
}
