import java.io.InputStream;
import java.net.Socket;
import javax.swing.JFrame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Date;

public class VisionRawListener extends VisionListener {
	static int width=88;
	static int height=72;
	static int channels=3;
	int pktSize=width*height*channels;
	byte[] _data=new byte[pktSize];
	byte[] _outd=new byte[pktSize];
	int[] _pixels=new int[width*height];;
	BufferedImage img=new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
	int bytesRead;
	boolean convertRGB=true;
	static int defPort=10011;

	void connected(Socket socket) {
		_isConnected=true;
		fireVisionUpdate();
		try {
			InputStream in=socket.getInputStream();
			_isConnected=true;
			while (true) {
				int br;
				bytesRead=0;
				while(bytesRead<pktSize) {
					br=in.read(_data,bytesRead,(pktSize-bytesRead>1024)?1024:(pktSize-bytesRead));
					bytesRead=bytesRead+br;
				}
				synchronized(_outd) {
					byte[] temp=_data;
					_data=_outd;
					_outd=temp;
					timestamp=new Date();
				}
				fireVisionUpdate();
			}
		} catch (Exception ex) { }
		
		try { socket.close(); } catch (Exception ex) { }
		_isConnected=false;
		fireVisionUpdate();
	}
	
	public byte[] getData() {
//		frameTimer();
		synchronized (_outd) {
			updatedFlag=false;
			return _outd;
		}
	}

	public void setConvertRGB(boolean b) { 
		if(b!=convertRGB) {
			convertRGB=b;
			updatedFlag=true;
			for(int i=0; i<listeners.size(); i++)
				((VisionUpdatedListener)listeners.get(i)).visionUpdated(this);
		}
	}
	public boolean getConvertRGB() { return convertRGB; }

	public int[] getYUVPixels() {
		synchronized(_outd) {
			byte[] data=getData();
			int offset=0;
			for (int i=0; i<width*height; i++) {
				int y=(int)data[offset++]&0xFF;
				int u=(int)data[offset++]&0xFF;
				int v=(int)data[offset++]&0xFF;
			_pixels[i]=(255<<24) | (y<<16) | (u<<8) | v;
			}
		}
		return _pixels;
	}

	public int[] getRGBPixels() {
		synchronized(_outd) {
			byte[] data=getData();
			int offset=0;
			for (int i=0; i<width*height; i++) {
				int y=(int)data[offset++]&0xFF;
				int u=(int)data[offset++]&0xFF;
				int v=(int)data[offset++]&0xFF;
				u=u*2-255;
				v=v*2-255;
				int r=y+u;
				int b=y+v;
				u=u>>1;
				v=(v>>2)-(v>>4);
				int g=y-u-v;
				//			r=r&0xFF; g=g&0xFF; b=b&0xFF;
				if (r<0) r=0; if (g<0) g=0; if (b<0) b=0;
				if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;
				
				_pixels[i]=(255<<24) | (r<<16) | (g<<8) | b;
			}
		}
		return _pixels;
	}

	public BufferedImage getImage() {
		int[] data=getConvertRGB()?getRGBPixels():getYUVPixels();
		img.setRGB(0,0,width,height,data,0,width);
		return img;
	}
	
	public VisionRawListener() { super(); }
	public VisionRawListener(int port) { super(port); }
	public VisionRawListener(String host, int port) { super(host,port); }
}
