import java.awt.event.*;
import javax.swing.*;
import java.lang.String;
import java.util.LinkedList;
import java.awt.*;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.DataBuffer;
import java.util.Date;
import java.io.PrintWriter;
import java.io.FileOutputStream;

public class ImageSequenceWriterThread extends Thread implements VisionUpdatedListener {
	String dir;
	String pre;
	String post;
	String fmt;
	LinkedList imgBufs=new LinkedList();
	int dig;
	LinkedList q=new LinkedList();
	int count=0;
	VisionListener listen;
	boolean stopping=false;
	JButton but;

	public ImageSequenceWriterThread(VisionListener l, JButton reenableBut) {
		super("ImageSequenceWriter");
		int initbufsize=500;
		but=reenableBut;
		listen=l;
		l.addListener(this);
		BufferedImage i=l.getImage();
		if(i.getColorModel().getTransferType()!=DataBuffer.TYPE_BYTE)
			for(int j=0;j<initbufsize;j++)
				imgBufs.add(new BufferedImage(i.getWidth(),i.getHeight(),i.getType()));
		else {
			for(int j=0;j<initbufsize;j++)
				imgBufs.add(new BufferedImage(i.getWidth(),i.getHeight(),i.getType(),(IndexColorModel)i.getColorModel()));
		}
	}

	public void setDirectory(String directory) {
		dir=directory;
	}

	public void setName(String prepend, int digits, String append, String format) {
		pre=prepend;
		post=append;
		fmt=format;
		dig=digits;
	}

	public void visionUpdated(VisionListener l) {
		push(l.getImage(),l.getTimeStamp());
	}

	public void push(BufferedImage i, Date t) {
		BufferedImage i2;
		if(imgBufs.size()>0)
			i2=(BufferedImage)imgBufs.removeFirst();
		else {
			if(i.getColorModel().getTransferType()!=BufferedImage.TYPE_BYTE_INDEXED)
				i2=new BufferedImage(i.getWidth(),i.getHeight(),i.getType());
			else
				i2=new BufferedImage(i.getWidth(),i.getHeight(),i.getType(),(IndexColorModel)i.getColorModel());
		}
		i.copyData(i2.getRaster());
		synchronized(q) {
			q.addLast(i2);
			q.addLast(t);
		}
	}

	public void run() {
		String tmp=null;
		PrintWriter log;
		try {
			log=new PrintWriter(new FileOutputStream(dir+pre+post+".txt"));
		} catch(Exception ex) { ex.printStackTrace(); return; }
		Date start=null;
		try {
			while(true) {
				while(q.size()>0) {
					if(interrupted()) {
						if(!stopping) {
							stopping=true;
							if(but!=null) {
								but.setEnabled(false);
								tmp=but.getText();
								but.setText("Writing...");
							}
							listen.removeListener(this);
						} else { //second interrupt... die!
							break;
						}
					}
					BufferedImage i;
					Date t;
					synchronized(q) {
						i=(BufferedImage)q.removeFirst();
						t=(Date)q.removeFirst();
					}
					if(start==null)
						start=t;
					long dt=t.getTime()-start.getTime();
					String name=getFileName(dt);
					log.println(name+"\t"+dt);
					ImageIO.write(i,fmt,new FileOutputStream(dir+name));
					imgBufs.addLast(i);
					count++;
				}
				if(stopping)
					break;
				sleep(1000/25);
			}
		} catch(Exception ex) {}
		log.close();
		if(but!=null && tmp!=null) {
			but.setEnabled(true);
			if(but.getText().compareTo("Writing...")==0)
				but.setText(tmp);
		}
	}

	protected String getFileName(long dt) {
		String ans=pre;
		long c=count;
		int digits=dig;
		if(digits==0) {
			c=dt;
			digits=6;
		}
		for(int s=(int)Math.pow(10,digits-1); s>=1; s/=10) {
			ans+=c/s;
			c-=(c/s)*s;
		}
		ans+=post+"."+fmt;
		return ans;
	}
}
