#include <vector>
#include "Shared/plist.h"
#include "Events/VisionObjectEvent.h"
#include <cmath>

using namespace plist;
using namespace std;

int main(int argc, const char** argv) {
	Dictionary outer;
	
	// Dictionary within a dictionary
	Dictionary inner;
	// This inner dictionary will be labeled "numeric" in the outer dictionary
	outer.addEntry("numeric",inner,"numeric contains some numeric values\n\tOne is a float\n\tThe other is an int\n\t...and a char as text for good measure");
	
	// These numeric tests will be stored in the inner dictionary
	Primitive<int> fooI=42;
	inner.addEntry("fooI",fooI,"This is an integer value, the other is a float");
	
	Primitive<float> fooF=M_PI;
	inner.addEntry("fooF",fooF);
	
	// chars can be treated as either a character (i.e. one letter
	// string) or a byte (i.e. 8 bit value)
	Primitive<char> fooC1='a'; // by default is a letter
	fooC1.setNumeric(false);  // can confirm this through setNumeric
	inner.addEntry("char-text",fooC1);
	
	Primitive<char> fooC2('a',true); //...can also setNumeric through constructor
	inner.addEntry("char-num",fooC2);
	
	// OK, back to add some more to the outer dictionary
	Primitive<std::string> str("Hello world!");
	outer.addEntry("test str",str,"Seen this one before?");
	
	Array mixed;
	outer.addEntry("Mixed",mixed,"A collection of mixed types of specified length");
	Primitive<int> itema=0; mixed.addEntry(itema);
	Primitive<int> itemb=1; mixed.addEntry(itemb);
	Primitive<int> itemc=2; mixed.addEntry(itemc);
	Primitive<std::string> item1="This is item 1"; mixed.addEntry(item1);
	Primitive<std::string> item2="item 2: arrays can contain mixed types"; mixed.addEntry(item2);
	Primitive<float> item3 = 123; mixed.addEntry(item3,"like this int");
	Primitive<bool> item4 = true; mixed.addEntry(item4,"or this bool");
	//mixed.addEntry("dynamic, heap-allocated entries supported too");
	
	Array vec(true); // there's also variable sized collections
	outer.addEntry("vector",vec,"The squares, from 0 to 5");
	for(int i=0; i<5; i++)
		vec.addValue(i*i); //now we use value types, the vector maintains the Primitive<>'s internally
	vec.addValue("can also handle mixed");
	
	Dictionary m(true); // named variable sized collections
	outer.addEntry("map",m,"The squares, from 0 to 5, but with keys");
	for(int i=0; i<5; i++) {
		stringstream ss;
		ss << i << "^2";
		m.addValue(ss.str(),i*i); //now we use value types, the vector maintains the Primitive<>'s internally
	}
	m.addValue("tada","mixed types -- no surprise");
	
	cout << outer;
	
	if(!outer.saveFile("virgin.plist")) {
		cerr << "Save virgin had error" << endl;
		return 1;
	}
	if(!outer.loadFile("loadtest.plist")) {
		cerr << "Load test had error" << endl;
		return 1;
	}
	str="Hello World, again!";
	if(!outer.saveFile("savetest.plist")) {
		cerr << "Save test had error" << endl;
		return 1;
	}
	
	VisionObjectEvent e(0,EventBase::activateETID);
	e.setTimeStamp(0); // ensures precisely repeatable results
	e.saveFile("vision.event");
	return 0;
}
