//-*-c++-*-
#ifndef INCLUDED_sim_h_
#define INCLUDED_sim_h_

#include "Events/EventTranslator.h"
#include "IPC/MessageQueue.h"
#include "SharedGlobals.h"
#include "IPC/SharedObject.h"
#include "IPC/Thread.h"
#include "Wireless/Wireless.h"
#include "Shared/ProjectInterface.h"
#include <vector>
class SimConfig;

class sim {
public:
	sim();
	bool processCommandLine(int argc, const char* argv[]);
	bool run();
	~sim();
	
	typedef MessageQueue<50> EventQueue_t;
	typedef MessageQueue<50> MotionCommandQueue_t;
	typedef MessageQueue<50> SoundPlayQueue_t;
	typedef MessageQueue<1> CameraQueue_t;
	typedef MessageQueue<1> SensorQueue_t;
	typedef MessageQueue<1> TimerWakeup_t;
	typedef MessageQueue<1> MotionWakeup_t;
	typedef MessageQueue<ProcessID::NumProcesses+1> StatusRequest_t;
	typedef MessageQueue<1> MotionOutput_t;
	
	static SimConfig config;
	static std::vector<std::string> assignments;
	
protected:
	unsigned int measure_usleep_cost();
	void wait_runlevel(SharedGlobals::runlevel_t level);
	template<class T> void manage_process();
	template<class T> bool fork_process();

	static unsigned int sim_get_time() { return globals?globals->get_time():0; }
	static float sim_getTimeScale() { return globals?globals->getTimeScale():0; }
	
	static void handle_signal(int sig);
	static void handle_exit();

	SharedObject<SemaphoreManager> mutexSemMgr;
	SharedObject<SharedGlobals> glob;
	SharedObject<ipc_setup_t> subj;
	static bool original;
	static const char * const usage;
	pid_t child;
};

class WirelessThread : public Thread {
public:
	//! constructor
	WirelessThread() : Thread() {}
	//! destructor -- stop thread
	virtual ~WirelessThread() {
		if(isRunning()) {
			stop();
			join();
		}
	}
	virtual unsigned int runloop() {
		// initial setup done by wireless's own constructor
		wireless->pollTest(NULL); // by passing NULL, we wait indefinitely, so no need to usleep in the Thread code
		wireless->pollProcess();
		wireless->pollSetup(); // reinitialize for next test
		return 0; //no sleep time because pollTest blocks
	}
	virtual void stop() {
		Thread::stop();
		wireless->wakeup();
	}
};


/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2006/10/03 23:11:37 $
 */

#endif
