//-*-c++-*-
#ifndef INCLUDED_SimConfig_h_
#define INCLUDED_SimConfig_h_

#include "Shared/plist.h"
#include "SharedGlobals.h"

//! Provides the root dictionary of the simulator configuration, items from SharedGlobals and LoadFileThreads are added as entries in this dictionary
class SimConfig : public plist::Dictionary {
public:
	SimConfig() : 
		cmdPrompt("sim >"),
		initSimTime(0),
		tgtRunlevel(SharedGlobals::RUNNING, SharedGlobals::runlevel_names, SharedGlobals::NUM_RUNLEVELS),
		lastfile()
	{
		setUnusedWarning(false);
		addEntry("InitialTime",initSimTime,"The value to initialize the simulator's clock (in milliseconds)");
		addEntry("InitialRunlevel",tgtRunlevel,"Specifies how far startup should proceed before pausing for user interaction.\nThis value only affects startup, and setting this value from the simulator command prompt will have no effect.  (Use the 'runlevel' command instead.)");
	}
	
	std::string cmdPrompt; //!< not persistently stored -- [re]set by main(...) on each run
	plist::Primitive<unsigned int> initSimTime;
	plist::NamedEnumeration<SharedGlobals::runlevel_t> tgtRunlevel;

	void setLastFile(const std::string& str) const {
		lastfile=str;
	}
	const std::string& getLastFile() const {
		return lastfile;
	}
	virtual	unsigned int loadFile(const char* filename) {
		lastfile=filename;
		return Dictionary::loadFile(filename);
	}
	virtual unsigned int saveFile(const char* filename) const {
		lastfile=filename;
		return Dictionary::saveFile(filename);
	}
	
protected:
	mutable std::string lastfile;
};

/*! @file
 * @brief Provides the root dictionary of the simulator configuration, items from SharedGlobals and LoadFileThreads are added as entries in this dictionary
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2006/09/28 20:42:52 $
 */

#endif
