//-*-c++-*-
#ifndef INCLUDED_Process_h_
#define INCLUDED_Process_h_

#include "IPC/ProcessID.h"
#include <string>

class RCRegion;

//! Represents a common interface for each process being run
class Process {
public:
	Process(ProcessID::ProcessID_t pid, const std::string& pname);
	virtual ~Process();
	virtual void DoStart() {}
	virtual void DoStop() {}
	virtual void run();

	static const std::string& getName() { return name; }
	static Process * getCurrent() { return current; }
	
	virtual void statusReport(std::ostream& os);
	static bool statusReport(RCRegion* msg);

protected:
	static std::string name;
	static Process * current;
	
private:
	Process(const Process&);            //!< don't call
	Process& operator=(const Process&); //!< don't call
};

/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2006/06/17 01:15:38 $
 */

#endif
