//-*-c++-*-
#ifndef INCLUDED_LoadImageThread_h_
#define INCLUDED_LoadImageThread_h_

#include "LoadFileThread.h"

class LoadImageThread : public LoadFileThread {
public:
	LoadImageThread(std::string source, std::string filter, float fps, MessageQueueBase& messages, bool doLoad=true);
	~LoadImageThread();

	virtual bool loadFile(const std::string& file, RCRegion*& data);
	using LoadFileThread::loadFile; // there's also the LoadSave function by the same name for loading parameters from a file
	
protected:
	virtual char* setupRegion(RCRegion*& region, const std::string& filename, unsigned int width, unsigned int height, unsigned int components);
	using LoadFileThread::setupRegion;
	virtual void sendHeartbeat() { frameIndex++; LoadFileThread::sendHeartbeat(); }

	struct jpeg_decompress_struct* cinfo; //!< used to interface with libjpeg - holds compression parameters and state
	struct jpeg_error_mgr* jerr;          //!< used to interface with libjpeg - gives us access to error information
	unsigned int frameIndex; //!< serial number, incremented for each frame loaded
	plist::Primitive<int> layer;
	
private:
	LoadImageThread(const LoadImageThread&); //!< don't call
	LoadImageThread& operator=(const LoadImageThread&); //!< don't call
};

/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2006/09/28 20:42:51 $
 */

#endif
