//-*-c++-*-
#ifndef INCLUDED_string_util_h
#define INCLUDED_string_util_h

#include "attributes.h"
#include <string>
#include <vector>

//! some common string processing functions, for std::string
namespace string_util {
	//! returns lower case version of @a s
	std::string makeLower(const std::string& s) ATTR_must_check;

	//! returns upper case version of @a s
	std::string makeUpper(const std::string& s) ATTR_must_check;

	//! returns @a str with @a pre removed - if @a pre is not fully matched, @a str is returned unchanged
	std::string removePrefix(const std::string& str, const std::string& pre) ATTR_must_check;
	
	//! removes whitespace (as defined by isspace()) from the beginning and end of @a str, and returns the result
	std::string trim(const std::string& str) ATTR_must_check;
	
	//! parses the input string into an arg list, with corresponding offsets of each arg in the original input
	bool parseArgs(const std::string& input, std::vector<std::string>& args, std::vector<unsigned int>& offsets); 

	//! replaces ~USER prefix with specified user's home directory, or ~ prefix with current HOME environment setting; returns str if no valid expansion is found
	std::string tildeExpansion(const std::string& str) ATTR_must_check;
};

/*! @file
 * @brief Describes some useful functions for string manipulation in the string_util namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2006/03/16 22:24:30 $
 */

#endif
