#include "string_util.h"
#include <ctype.h>
#include <pwd.h>
#include <stdlib.h>

using namespace std;

namespace string_util {

	string makeLower(const string& s) {
		string ans(s.size(),'#');
		unsigned int i=s.size();
		while(i--!=0)
			ans[i]=::tolower(s[i]);
		return ans;
	}

	string makeUpper(const string& s) {
		string ans(s.size(),'#');
		unsigned int i=s.size();
		while(i--!=0)
			ans[i]=::toupper(s[i]);
		return ans;
	}

	string removePrefix(const string& str, const string& pre) {
		if(str.compare(0,pre.size(),pre)==0)
			return str.substr(pre.size());
		return string();
	}
	
	string tildeExpansion(const string& str) {
		string ans;
		if(str[0]!='~') {
			return str;
		}
#ifndef PLATFORM_APERIOS
		else if(str=="~" || str[1]=='/') {
			char* home=getenv("HOME");
			if(home==NULL)
				return str;
			if(str=="~")
				return home;
			return home+str.substr(1);
		} else {
			string::size_type p=str.find('/');
			struct passwd * pw;
			pw=getpwnam(str.substr(1,p-1).c_str());
			if(pw==NULL)
				return str;
			return pw->pw_dir+str.substr(p);
		}
#else
		return str.substr(1);
#endif
	}

	string trim(const string& str) {
		if(str.size()==0)
			return str;
		unsigned int b=0;
		unsigned int e=str.size()-1;
		while(b<str.size() && isspace(str[b]))
			b++;
		while(b<e && isspace(str[e]))
			e--;
		return str.substr(b,e-b+1);
	}
	
	bool parseArgs(const string& input, vector<string>& args, vector<unsigned int>& offsets) {
		string cur;
		bool isDoubleQuote=false;
		bool isSingleQuote=false;
		args.clear();
		offsets.clear();
		unsigned int begin=-1U;
		for(unsigned int i=0; i<input.size(); i++) {
			char c=input[i];
			if(begin==-1U && !isspace(c))
				begin=i;
			switch(c) {
			case ' ':
			case '\n':
			case '\r':
			case '\t':
			case '\v':
			case '\f':
				if(isSingleQuote || isDoubleQuote)
					cur+=c;
				else if(cur.size()!=0) {
					args.push_back(cur);
					offsets.push_back(begin);
					cur.clear();
					begin=-1U;
				}
				break;
			case '\\':
				if(i==input.size()-1) { //escaped line break
					return false;
				} else
					cur.push_back(input[++i]);
				break;
			case '"':
				if(isSingleQuote)
					cur.push_back(c);
				else
					isDoubleQuote=!isDoubleQuote;
				break;
			case '\'':
				if(isDoubleQuote)
					cur+=c;
				else
					isSingleQuote=!isSingleQuote;
				break;
			default:
				cur+=c;
				break;
			}
		}
		if(cur.size()>0) {
			args.push_back(cur);
			offsets.push_back(begin);
		}
		return !isDoubleQuote && !isSingleQuote;
	}

}

/*! @file
 * @brief Implements some useful functions for string manipulation in the string_util namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2006/03/16 22:07:28 $
 */
