#include "plistBase.h"
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

//better to put this here instead of the header
using namespace std; 

namespace plist {
	
	ObjectBase::ObjectBase()
	: XMLLoadSave()
	{}
	
	ObjectBase::~ObjectBase() {}
	
	void ObjectBase::setParseTree(xmlDoc * doc) const {
		XMLLoadSave::setParseTree(doc);
		if(xmldocument==NULL)
			return;
		xmlNodePtr cur = xmlNewNode(NULL,(const xmlChar*)"plist");
		xmlNewProp(cur,(const xmlChar*)"version",(const xmlChar*)"1.0");
		xmlDocSetRootElement(xmldocument,cur);
		xmlCreateIntSubset(xmldocument,(const xmlChar*)"plist",(const xmlChar*)"-//Apple Computer//DTD PLIST 1.0//EN",(const xmlChar*)"http://www.apple.com/DTDs/PropertyList-1.0.dtd");
	}
	
	xmlNode* ObjectBase::FindRootXMLElement(xmlDoc* doc) const {
		if(doc==NULL)
			return NULL;
		xmlNode* root=XMLLoadSave::FindRootXMLElement(doc);
		string filename;
		if(doc->name!=NULL && doc->name[0]!='\0') {
			filename="document '";
			filename+=doc->name;
			filename+="' ";
		}
		if (root == NULL)
			throw bad_format(root,"Error: plist read empty document");
		if (xmlStrcmp(root->name, (const xmlChar *)"plist"))
			throw bad_format(root,"Error: plist read document of the wrong type, root node != plist");
		if (!xmlHasProp(root,(const xmlChar*)"version"))
			cerr << "Warning: plist " << filename << "does not carry version number, assuming 1.0" << endl;
		else {
			xmlChar* strv=xmlGetProp(root,(const xmlChar*)"version");
			double version=strtod((const char*)strv,NULL);
			if(version>1.0)
				cerr << "WARNING: plist " << filename << "is version " << strv << ", this software only knows 1.0.  Trying anyway..." << endl;
			if(version==0)
				cerr << "WARNING: plist " << filename << "seems to have invalid version '" << strv << "', this software only knows 1.0.  Trying anyway..." << endl;
			xmlFree(strv);
		}
		
		// find first element node within the plist
		xmlNode* cur=root->children;
		while(cur!=NULL && cur->type!=XML_ELEMENT_NODE)
			cur=cur->next;
		if(cur==NULL) //empty plist
			cur = xmlNewChild(root,NULL,(const xmlChar*)"",NULL);
		return cur;
	}
	
	bool ObjectBase::xNodeHasName(xmlNode* node, const char* name) {
		return xmlStrcasecmp(node->name,(const xmlChar*)name)==0;
	}
	const xmlChar* ObjectBase::xNodeGetName(xmlNode* node) {
		return node->name;
	}
	xmlNode* ObjectBase::xNodeGetChildren(xmlNode* node) {
		return node->children;
	}
	xmlNode* ObjectBase::xNodeGetNextNode(xmlNode* node) {
		return node->next;
	}
	xmlNode* ObjectBase::xNodeGetParent(xmlNode* node) {
		return node->parent;
	}
	xmlDoc* ObjectBase::xNodeGetDoc(xmlNode* node) {
		return node->doc;
	}
	
	
	PrimitiveBase::~PrimitiveBase() {
		delete primitiveListeners;
		primitiveListeners=NULL;
	}
	
	void PrimitiveBase::addPrimitiveListener(PrimitiveListener* vl) {
		if(vl!=NULL) {
			if(primitiveListeners==NULL)
				primitiveListeners=new std::list<PrimitiveListener*>;
			primitiveListeners->push_back(vl);
		}
	}
	void PrimitiveBase::removePrimitiveListener(PrimitiveListener* vl) {
		if(primitiveListeners==NULL)
			return;
		std::list<PrimitiveListener*>::iterator it=find(primitiveListeners->begin(),primitiveListeners->end(),vl);
		if(it!=primitiveListeners->end()) {
			primitiveListeners->erase(it);
			if(primitiveListeners->empty()) {
				delete primitiveListeners;
				primitiveListeners=NULL;
			}
		}
	}
	bool PrimitiveBase::isPrimitiveListener(PrimitiveListener* vl) {
		if(vl==NULL)
			return false;
		if(primitiveListeners==NULL)
			return false;
		std::list<PrimitiveListener*>::iterator it=find(primitiveListeners->begin(),primitiveListeners->end(),vl);
		return it!=primitiveListeners->end();
	}
	void PrimitiveBase::fireValueChanged() const {
		if(primitiveListeners==NULL)
			return;
		std::list<PrimitiveListener*>::const_iterator it=primitiveListeners->begin();
		while(it!=primitiveListeners->end()) {
			std::list<PrimitiveListener*>::const_iterator cur=it++; //increment early in case the listener changes subscription
			(*cur)->plistValueChanged(*this);
		}
	}
		
} //namespace plist


/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2005/12/22 21:32:28 $
 */
