//-*-c++-*-
#ifndef INCLUDED_PListSupport_h_
#define INCLUDED_PListSupport_h_

#include "plistBase.h"
#include "plistPrimitives.h"
#include "plistCollections.h"

namespace plist {
	
	//! From the name of @a node, will instantiate a new ObjectBase subclass to load it
	/*! The mapping from node names to actual instantiated types is: 
	 *    - 'array' -> Vector
	 *    - 'dict' -> Map
	 *    - 'real' -> Primitive<double>
	 *    - 'integer' -> Primitive<long>
	 *    - 'string' -> Primitive<std::string>
	 *    - 'true', 'false' -> Primitive<bool>
	 *  
	 *  If successful, returns a pointer to a newly allocated region, which the caller is
	 *  responsible for freeing.  If an error occurs, NULL is returned.
	 */
	ObjectBase* loadXML(xmlNode* node);
	
	//! Attempts to parse the file found at @a file, using plist::loadXML()
	ObjectBase* loadFile(const std::string& file);
	
	//! Attempts to parse the buffer found at @a buf, using plist::loadXML()
	ObjectBase* loadBuffer(const char* buf, unsigned int len);
	
} //namespace plist

/*! @file
 * @brief Provides the plist namespace, a collection of classes to implement the Propery List data storage format, a XML standard used by Apple and others
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2006/09/09 04:33:02 $
 */

#endif
