//-*-c++-*-
#ifndef __mathutils_h__
#define __mathutils_h__

#include <math.h>

namespace mathutils {
  template <class num>
  inline num squareDistance(num x1, num ya, num x2, num yb) {
    return (x1-x2)*(x1-x2)+(ya-yb)*(ya-yb);
  }

  template <class num>
  inline num distance(num x1, num ya, num x2, num yb) {
    return sqrt(squareDistance(x1, ya, x2, yb));
  }

  template <class num>
  inline num limitRange(num n, num low, num high) {
    if (n<low) n=low;
    if (n>high) n=high;
    return n;
  }

  template <class num>
  inline num squared(num n) {
    return n*n;
  }

  template <class num>
  inline num abs_t(num n) {
    return (n>-n)?n:-n;
  }

	template <class num>
	inline num log2t(num x) {
		num ans=0;
		for(unsigned int mag=sizeof(num)*4; mag>0; mag/=2) {
			num y=x>>mag;
			if(y>0) {
				x=y;
				ans+=mag;
			}
		}
		return ans;
	}
	template <>
	inline float log2t(float x) {
		return log(x)/M_LN2;
	}
	template <>
	inline double log2t(double x) {
		return log(x)/M_LN2;
	}

  template <class num>
  inline num deg2rad(num x) {
    return x*M_PI/180;
  }

  template <class num>
  inline num rad2deg(num x) {
    return x*180/M_PI;
  }

}

#endif
