//-*-c++-*-
#ifndef INCLUDED_RobotInfo_h
#define INCLUDED_RobotInfo_h

#if TGT_ERS220
#	include "ERS220Info.h"
#elif TGT_ERS210
#	include "ERS210Info.h"
#elif TGT_ERS2xx
#	include "ERS2xxInfo.h"
#elif TGT_ERS7
#	include "ERS7Info.h"
#else //default case, currently ERS-7
#	warning "TGT_<model> undefined or unknown model set - defaulting to ERS7 (valid values are TGT_ERS210, TGT_ERS220, TGT_ERS2xx, or TGT_ERS7)"
#	include "ERS7Info.h"
#endif //model selection

//! Contains information about the robot, such as number of joints, PID defaults, timing information, etc.
/*! This is just a wrapper for whichever namespace corresponds to the current
 *  robot target setting (one of TGT_ERS7, TGT_ERS210, TGT_ERS220, or the cross-booting TGT_ERS2xx)
 *
 *  You probably should look at ERS7Info, ERS210Info, ERS220Info, or ERS2xxInfo for the actual
 *  constants used for each model, although some common information shared by all of these namespaces
 *  is defined in CommonInfo.h */
namespace RobotInfo {

#if TGT_ERS220
	using namespace ERS220Info;
#elif TGT_ERS210
	using namespace ERS210Info;
#elif TGT_ERS7
	using namespace ERS7Info;
#elif TGT_ERS2xx
	using namespace ERS2xxInfo;
#else //default case, ERS7
	using namespace ERS7Info;
#endif //model selection	
}

using namespace RobotInfo;
	
/*! @file
 * @brief Checks the define's to load the appropriate header and namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.17 $
 * $State: Exp $
 * $Date: 2006/10/03 23:06:58 $
 */

#endif
