#include "ProcessID.h"

#include "Shared/WorldState.h"

#ifdef PLATFORM_APERIOS
#  include <iostream>
using namespace stacktrace;
#endif

using namespace std;

namespace ProcessID {
	ProcessID_t ID=NumProcesses; //!< holds ID number
	
#ifndef PLATFORM_APERIOS
	// on "normal" platforms we can trust the id specified by the process to stay consistent
	ProcessID_t getID() { return ID; }

#else
	// but on the Aibo, we have to unroll the stack to see which thread it is

	//! array of StackFrame structures, one per #NumProcesses, set by setMap()
	StackFrame* frames=NULL;
	
	//! 
	void setMap(stacktrace::StackFrame idmap[]) {
		frames=idmap;
	}
	
	stacktrace::StackFrame* getMapFrame() {
		if(frames==NULL) //setMap hasn't been called yet
			return NULL;
		if(ID==NumProcesses) // ID hasn't been set
			return NULL;
		return &frames[ID];
	}


	ProcessID_t getID() {
		if(frames==NULL) { //setMap hasn't been called yet
			//cerr << "getID() called before setMap() id==" << ID << endl;
			//displayCurrentStackTrace();
			return ID;
		}
		StackFrame f;
#ifdef DEBUG_STACKTRACE
		f.debug=(state!=NULL)?(state->buttons[LFrPawOffset]>.1):1;
		if(f.debug)
			fprintf(stderr,"getID() for %d: ",ID);
#endif
		getCurrentStackFrame(&f);
		while(unrollStackFrame(&f,&f)) {}
		for(unsigned int i=0; i<NumProcesses; i++) {
			if(frames[i].gp==f.gp) {
#ifdef DEBUG_STACKTRACE
				if(i!=(unsigned int)ID || f.debug)
					cout << "getID() from " << ID << " is " << i << endl;
#endif
				return static_cast<ProcessID_t>(i);
			}
		}
		cerr << "ERROR: Unknown entry point (sp=" << f.sp << ",ra=" << (void*)f.ra << ",gp=" << (void*)f.gp << "), implied process " << ID << endl;
		displayCurrentStackTrace();
		cerr << "Map:" << endl;
		for(unsigned int i=0; i<NumProcesses; i++)
			cerr << "  " << i << " (sp=" << frames[i].sp << ",ra=" << (void*)frames[i].ra << ",gp=" << (void*)frames[i].gp << ")" << endl;
		return ID;
	}

#endif

	void setID(ProcessID_t id) { ID=id; }
}



/*! @file
 * @brief Declares the static ProcessID::ID, that's all
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2006/09/16 06:01:40 $
 */

