//-*-c++-*-
#ifndef INCLUDED_Pilot_h_
#define INCLUDED_Pilot_h_

#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"

class EventBase;

namespace DualCoding {

class ShapeRoot;

class PilotRequest {
public:

  enum requestType_t {
    reactiveWalk,
    waypointWalk,
    gotoShapeWalk,
  } requestType;

  typedef struct Motion {
    enum PilotMotionType_t {
      transX=0,
      transY,
      rotate,
    } type;

    float val; // val of translation(mm/sec)/rotation(rad/sec)
    Motion& operator=(const Motion& other) {
      if (&other == this) return *this;
      type = other.type;
      val = other.val;
      return *this;
    }

    Motion(const Motion& m) : type(m.type), val(m.val) {}
    Motion(PilotMotionType_t t, float s) : type(t), val(s) {}
  };

  typedef struct Constraint {
    enum PilotConstraintType_t {
      coordX,
      coordY,
      angle,
      distance,
    } type;

    float val; // holds address of constraint
    Constraint& operator=(const Constraint& other) { 
      if (&other == this) return *this;
      type = other.type;
      val = other.val;//(NULL==other.val) ? NULL : &(*other.val);
      return *this;
    }
    Constraint(PilotConstraintType_t t, float v) : type(t), val(v) {}//&v) {}
    Constraint(const Constraint& r) : type(r.type), val(r.val) {} //&(*r.val)) {}
  };

  unsigned int request_id;
  vector<Motion> motions;
  vector<Constraint> constraints;

private:
  PilotRequest(requestType_t _reqType, unsigned int _request_id, 
	       const vector<Motion>& _motions, const vector<Constraint>& _constraints)
    : requestType(_reqType), request_id(_request_id), motions(_motions), constraints(_constraints) 
  { if (constraints.size() > 2) constraints.resize(2, Constraint(constraints.front()));
    if (motions.size() > 2) motions.resize(2, Motion(motions.front())); }
  PilotRequest(requestType_t _reqType, unsigned int _request_id, const Motion& _motion, 
	       const vector<Constraint>& _constraints)
    : requestType(_reqType), request_id(_request_id), motions(), constraints(_constraints) 
  { if (constraints.size() > 2) constraints.resize(2, Constraint(constraints.front()));
    motions.push_back(_motion); }
    
public:
  // reactive walk
  static PilotRequest Rotate(unsigned int _request_id, float speed, const vector<Constraint>& _constraints)
  { return PilotRequest(reactiveWalk, _request_id, Motion(Motion::rotate,speed), _constraints); }
  static PilotRequest translateX(unsigned int _request_id, float speed, const vector<Constraint>& _constraints)
  { return PilotRequest(reactiveWalk, _request_id, Motion(Motion::transX,speed), _constraints); }
  static PilotRequest translateY(unsigned int _request_id, float speed, const vector<Constraint>& _constraints)
  { return PilotRequest(reactiveWalk, _request_id, Motion(Motion::transY,speed), _constraints); }

  // waypoint walk 
  PilotRequest(unsigned int _request_id, const Motion& _motion)
    : requestType(waypointWalk), request_id(_request_id), motions(), constraints() { motions.push_back(_motion); }
  static PilotRequest Rotate(unsigned int _request_id, float dest)
  { return PilotRequest(_request_id, Motion(Motion::rotate,dest)); }
  static PilotRequest translateX(unsigned int _request_id, float dest)
  { return PilotRequest(_request_id, Motion(Motion::transX,dest)); }
  static PilotRequest translateY(unsigned int _request_id, float dest)
  { return PilotRequest(_request_id, Motion(Motion::transY,dest)); }

  // gotoShape walk
  static PilotRequest GotoShape(unsigned int _req_id)
  { return PilotRequest(gotoShapeWalk,_req_id,vector<Motion>(),vector<Constraint>()); }

  
  PilotRequest& operator=(const PilotRequest& other) {
    if (&other == this) return *this;
    requestType = other.requestType;
    request_id = other.request_id;
    motions = other.motions;
    constraints = other.constraints;
    return *this;
  }
};


class Pilot : public BehaviorBase {
private:
  vector<PilotRequest> requests;
  //  vector<unsigned int> colors;

  void removeCurrentRequest() {
    if (!requests.empty())
      requests.erase(requests.begin());
  }
  void executeRequest() {}//;
  /*  
  void processReactiveWalk(const EventBase& e);
  void processWaypointWalk(const EventBase& e);
  void processGotoShape(const EventBase& e);
  enum RequestIDs {
    lookAtID,
    trackID,
  };
  */
public:
  //! Constructor
  Pilot() : BehaviorBase("Pilot"), requests() {} //;

  //  virtual void DoStart();
  //  virtual void DoStop();
  //  virtual void processEvent(const ::EventBase &e);
  virtual void executeRequest(const PilotRequest &req) {
    if (!requests.empty()) {
      cout << "Pilot busy\n";
      return;
    }
    requests.push_back(req);
    executeRequest();
  }
  void gotoShape(const ShapeRoot&) {}//;
  void turnBy(AngTwoPi){}//;

  //  MotionManager::MC_ID walker_id;
  //  MotionManager::MC_ID waypoint_id;
};

} // namespace

#endif
