//-*-c++-*-

#ifndef _LOADED_Particle_h_
#define _LOADED_Particle_h_

#include <vector>
#include <iostream>

#include "Measures.h"     // coordinate_t, AngTwoPi

using namespace std;

namespace DualCoding {

//! Each Particle represents a hypothesis about the match of the local map to the world map.

class Particle {
 public:
  coordinate_t dx, dy;		//!< Translation from local to world coordinates
  AngTwoPi theta;		//!< Rotation of local map into world map
  vector<bool> addLocal;	//!< true for local landmarks missing from the world map
  // vector<bool> deleteWorld;	//!< true for world landmarks missing from the local map
  float prob;			//!< Computed likelihood of this Particle

  //! Constructor
  Particle() : dx(0), dy(0), theta(0), addLocal(),
  // deleteWorld(nworld,false),
	       prob(-1) {}

};

ostream& operator << (ostream& os, const Particle &p);
    
} // namespace

#endif
