//-*-c++-*-
#ifndef INCLUDED_Lookout_h_
#define INCLUDED_Lookout_h_

#include <queue>
#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/MotionSequenceMC.h"
#include "Events/VisionObjectEvent.h"
#include "LookoutRequests.h"

namespace DualCoding {

class LookoutRequest;
class StoreModeImageRequest;
class ModeImageRequest;

/*!
 The Lookout's job is to move the head and collect sensor information.
 Head motion can be none (user will point the head himself), pointAt, scan, or track.
 The data collected can be an image or distance reading, or for scan operations, it
 can be a list of locations where certain VisionObject or VisionRegion streams
 reported hits.

*/

class Lookout : public BehaviorBase {
public:
  //! Constructor
  Lookout();
  //! Destructor
  virtual ~Lookout() {}
  
  virtual void DoStart();
  virtual void DoStop();
  virtual void processEvent(const EventBase& event);

  static std::string getClassDescription() { return "moves head according to request"; }
  virtual std::string getDescription() const { return getClassDescription(); }

  virtual unsigned int executeRequest(const LookoutRequest&);
  //  virtual bool removeRequest(unsigned int req_id);
  //  bool isBusy() const { return !requests.empty(); }
  //  bool isLandmarkVisible() const { return landmark_inview; }
  //  bool isExecuting(LookoutRequest::HeadMotionType_t type) const 
  //  { return !requests.empty() && getCurrentRequest().getHeadMotionType() == type; }

  static Point findLocationFor(float, float);
  static const unsigned int Invalid_LO_ID=(unsigned int)-1;
  
protected:
  virtual void executeRequest();
  virtual void requestComplete();
  template<class T>
  void pushRequest(const LookoutRequest& req) {
    requests.push(new T(*dynamic_cast<const T*>(&req)));
  }
    

  //! PointAtReqeust
  void processPointAt(const EventBase& event);
  bool findPixelModes(StoreModeImageRequest& modeRequest);
  void getData();
  /*
  //! TrackRequest
  void processTrack(const EventBase& event);
  void processTrackVision(float normX, float normY, bool isCurrentlyVisible);
  void trackObjectAt(float normX, float normY); //! tracks point at [normX,normY] in cam frame
  Point findLocationFor(float, float);
  */
  //! ScanReqeust
  void processScan(const EventBase& event);
  void scan();
  void scanAlongLine(const Point& start,const Point& end);
  void scanArea(coordinate_t left, coordinate_t right,
		coordinate_t far, coordinate_t near);
  //  void storeRegionLocation(const SegmentedColorGenerator::color_class_state*);
  //  void storeVisionObjectLocation(const VisionObjectEvent*);
  Point findLocationFor(const VisionObjectEvent* voe) {
    return findLocationFor(voe->getCenterX(), voe->getCenterY());
  }
  Point findLocationFor(const CMVision::region* reg) {
    return findLocationFor
      (2.0*reg->cen_x/VRmixin::camSkS.getWidth()-1.0,
       2.0*reg->cen_y/VRmixin::camSkS.getHeight()-1.0);
  }

  void storeVisionRegionDataTo(vector<Point>&, const set<int>&, int);
  void storeIRDataTo(vector<Point>&);

  //  float scanSpeed() const { return  baseRange/base_pan_time; } //(rad/msec)
private:
  Lookout& operator=(const Lookout&);
  Lookout(const Lookout&);

protected:
  MotionManager::MC_ID pointer_id; //!< a HeadPointerMC object
  MotionManager::MC_ID sequence_id; //!< id for scan/find motion sequence
  queue<LookoutRequest*> requests;
  LookoutRequest *curReq;
  bool /*pan_prior, */landmarkInView;
  unsigned int idCounter;

  enum LookoutTimerSourceId_t {
    start_pan,
    pan_complete,
    reset_pan,
    no_event,
    dur_timer,
    scan_timer, //scan_timer has to be at the end of enum list
  };
};

} //namespace

#endif
