//-*-c++-*-
// Master include file list to be used by user behaviors.

#ifndef LOADED_DualCoding_h_
#define LOADED_DualCoding_h_

//! Dual coding vision representations (Sketches and Shapes)
namespace DualCoding {}

#include "Measures.h"
#include "ShapeTypes.h"
#include "SketchTypes.h"

#include "SketchSpace.h"
#include "ShapeSpace.h"
#include "ShapeFuns.h"

#include "SketchDataRoot.h"
#include "SketchData.h"
#include "SketchPoolRoot.h"
#include "SketchPool.h"
#include "Sketch.h"
#include "SketchIndices.h"
#include "Region.h"
#include "visops.h"

#include "Point.h"
#include "EndPoint.h"

#include "BaseData.h"
#include "ShapeRoot.h"

#include "LineData.h"
#include "ShapeLine.h"

#include "EllipseData.h"
#include "ShapeEllipse.h"

#include "PointData.h"
#include "ShapePoint.h"

#include "AgentData.h"
#include "ShapeAgent.h"

#include "SphereData.h"
#include "ShapeSphere.h"

#include "BlobData.h"
#include "ShapeBlob.h"

#include "PolygonData.h"
#include "ShapePolygon.h"

#include "BrickData.h"
#include "ShapeBrick.h"

#include "PyramidData.h"
#include "ShapePyramid.h"

#include "ViewerConnection.h"
#include "VisualRoutinesStateNode.h"
#include "VisualRoutinesBehavior.h" // this must preceed mapbuilders, pilot and lookout
#include "VRmixin.h"

#include "LookoutRequests.h"
#include "Lookout.h"
#include "MapBuilderRequests.h"
#include "MapBuilder.h"
#include "Pilot.h"

#include "Particle.h"
#include "ParticleShapes.h"
#include "ParticleFilter.h"

#endif
