//-*-c++-*-
#ifndef INCLUDED_EventTrans_h_
#define INCLUDED_EventTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition when the specified event is received

class EventTrans : public Transition {
private:
  int argcount; //!< the number of arguments which were supplied to the constructor (granularity of filtering)
  EventBase::EventGeneratorID_t egid; //!< the requested generator
  unsigned int esid; //!< the requested source
  EventBase::EventTypeID_t etid; //!< the requested type

public:
	//!@name Constructors
	//! follows general pattern of EventRouter::addListener()
  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid)
		: Transition("EventTrans",destination), argcount(1), egid(gid), esid(0), etid(EventBase::statusETID)
	{}

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid)
		: Transition("EventTrans",destination), argcount(2), egid(gid), esid(sid), etid(EventBase::statusETID)
	{}

  EventTrans(StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid, EventBase::EventTypeID_t tid)
		: Transition("EventTrans",destination), argcount(3), egid(gid), esid(sid), etid(tid)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid)
		: Transition("EventTrans",name,destination), argcount(1), egid(gid), esid(0), etid(EventBase::statusETID)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid)
		: Transition("EventTrans",name,destination), argcount(2), egid(gid), esid(sid), etid(EventBase::statusETID)
	{}

  EventTrans(const std::string& name, StateNode* destination, EventBase::EventGeneratorID_t gid, unsigned int sid, EventBase::EventTypeID_t tid)
		: Transition("EventTrans",name,destination), argcount(3), egid(gid), esid(sid), etid(tid)
	{}
	//@}

  //! starts listening
  virtual void DoStart() {
    Transition::DoStart();
    switch (argcount) {
    case 1: erouter->addListener(this,egid); break;
    case 2: erouter->addListener(this,egid,esid); break;
    case 3: erouter->addListener(this,egid,esid,etid);
    };
  }

  //! stops listening
  virtual void DoStop() {
    erouter->removeListener(this);
    Transition::DoStop();
  }

  //! fire the transition if an event is seen
  virtual void processEvent(const EventBase&) { fire(); }

};

/*! @file
 * @brief Defines EventTrans, which causes a transition if an event of the specified type occurs
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2004/12/23 01:47:07 $
 */

#endif
