#include "StareAtBallBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/MMAccessor.h"
#include "Shared/ProjectInterface.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void StareAtBallBehavior::DoStart() {
	BehaviorBase::DoStart();
	headpointer_id = motman->addPersistentMotion(SharedObject<HeadPointerMC>());
	erouter->addListener(this,EventBase::visObjEGID,ProjectInterface::visPinkBallSID);
}

void StareAtBallBehavior::DoStop() {
	erouter->removeListener(this);
	motman->removeMotion(headpointer_id);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void StareAtBallBehavior::processEvent(const EventBase& event) {
	float horiz=0,vert=0;
	if(event.getGeneratorID()==EventBase::visObjEGID && event.getTypeID()==EventBase::statusETID) {
		const VisionObjectEvent& objev=static_cast<const VisionObjectEvent&>(event);
		horiz=objev.getCenterX();
		vert=objev.getCenterY();
	}

	//cout << horiz << ' ' << vert << endl;

	// Very simple visual servoing control -- move the head a small distance in the direction of the target
	// This is "proportional" control, because we move the head proportionally further when the error (horiz and vert) is larger
	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/7;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/6;
	
	// now request access to the headpointer we added in DoStart and set the joint angles
	MMAccessor<HeadPointerMC> headpointer(headpointer_id);
	if(state->robotDesign & WorldState::ERS7Mask) {
		//on an ers-7, we want to set the nod joint to look up (maximum value), since tilt can only look down
		headpointer->setJoints(tilt,pan,outputRanges[HeadOffset+NodOffset][MaxRange]);
	} else {
		//on other models (we'll just assume ers-2xx), center the roll joint
		headpointer->setJoints(tilt,pan,0);
	}
}
			
/*! @file
 * @brief Implements StareAtBallBehavior, which points the head at the ball
 * @author tss (Creator)
 */


