#include "ShutdownControl.h"
#ifdef PLATFORM_APERIOS
#  include <OPENR/OPENRAPI.h>
#else
#  include "local/sim/SharedGlobals.h"
#endif

ControlBase * ShutdownControl::doSelect()    {
#ifdef PLATFORM_APERIOS
	OBootCondition bc(0);
	OPENR::Shutdown(bc);
#else
	if(globals!=NULL)
		globals->signalShutdown();
#endif
	return NULL;
}

/*! @file
 * @brief Implements ShutdownControl, which causes the aibo to shutdown (very short - one function separated out to limit recompile of the OPENR headers)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-3_0 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2005/08/31 21:55:12 $
 */

