#include "Shared/plist.h"
#include "Events/VisionObjectEvent.h"
#include <cmath>

using namespace plist;
using namespace std;

int main(int argc, const char** argv) {
  Primitive<int> fooI=42;
  Primitive<float> fooF=M_PI;
  Primitive<std::string> str("Hello world!");
	
  Dictionary outer;
  Dictionary inner;
  inner.addEntry("fooI",fooI,"This is an integer value, the other is a float");
  inner.addEntry("fooF",fooF);
  outer.addEntry("numeric",inner,"numeric contains some numeric values\n\tOne is a float\n\tThe other is an int");
  outer.addEntry("test str",str,"Seen this one before?");
	
  if(!outer.SaveFile("virgin.plist")) {
    cerr << "Save virgin had error" << endl;
    return 1;
  }
  if(!outer.LoadFile("loadtest.plist")) {
    cerr << "Load test had error" << endl;
    return 1;
  }
  str="Hello World, again!";
  if(!outer.SaveFile("savetest.plist")) {
    cerr << "Save test had error" << endl;
    return 1;
  }

  VisionObjectEvent e(0,EventBase::activateETID);
  e.SaveFile("vision.event");
  return 0;
}
