import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class ImageShow extends JFrame implements KeyListener {
  BufferedImage _image;
  String[] imglist;
  byte[] tmap;
  ImageData imageData;
  int curimg;
	boolean isRGB;

  public static void main(String args[]) {
    if (args.length<1)
			usageAndExit();
		boolean isRGB=true;
		if(args[0].equals("-isRGB"))
			isRGB=true;
		else if(args[0].equals("-isYUV"))
			isRGB=false;
		else {
			System.out.println(args[0]+" is not valid color mode");
			usageAndExit();
		}
		
		String files[]=new String[args.length-1];
		for(int i=0; i<files.length; i++)
			files[i]=args[i+1];

    ImageShow imageShow=new ImageShow(isRGB,files);
    imageShow.show();
    imageShow.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) { System.exit(0); } });
  }


	public static void usageAndExit() {
		System.out.println("usage: java ImageShow (-isRGB|-isYUV) raw_image [raw images]");
		System.exit(1);
	}

  public ImageShow (boolean isRGB, String args[]) {
    imageData=new ImageData();
		this.isRGB=isRGB;
		if(isRGB)
			imageData.loadRGBFileAsRGB(args[0]);
		else
			imageData.loadYUVFileAsRGB(args[0]);

    int[] data=imageData.getPixels();

    setBackground(Color.black);
    setSize(imageData.image_width*2, imageData.image_height*2);
    setTitle(args[0]);
    _image=new BufferedImage(imageData.image_width, imageData.image_height,
        BufferedImage.TYPE_INT_RGB);
   
    showImage(data, tmap, imageData.image_width, imageData.image_height);

    imglist=new String[args.length];
    curimg=0;
    for (int i=0; i<args.length; i++) {
      imglist[i]=args[i];
    }

    addKeyListener(this);
  }

  void showImage(int[] data, byte[] tmap, int width, int height) {
    _image.getRaster().setDataElements(0,0,width,height,data);
    repaint();
  }

  public void paint(Graphics graphics) {
    Dimension sz=getSize();
    if (_image!=null)
      graphics.drawImage(_image, 0, 0, sz.width, sz.height, null);
  }

  public int getPixel(int x, int y) {
    Dimension sz=getSize();
    x=(x*_image.getWidth())/sz.width;
    y=(y*_image.getHeight())/sz.height;
    return _image.getRGB(x, y);
  }

  public void keyPressed(KeyEvent e) {
    if (e.getKeyCode()==KeyEvent.VK_LEFT ||
        e.getKeyCode()==KeyEvent.VK_UP ||
        e.getKeyCode()==KeyEvent.VK_PAGE_UP ||
        e.getKeyCode()==KeyEvent.VK_KP_UP ||
        e.getKeyCode()==KeyEvent.VK_KP_LEFT) {
      curimg--;
      if (curimg<0) curimg+=imglist.length;
			if(isRGB)
				imageData.loadRGBFileAsRGB(imglist[curimg]);
			else
				imageData.loadYUVFileAsRGB(imglist[curimg]);
      int[] data=imageData.getPixels();
      showImage(data, tmap, imageData.image_width, imageData.image_height);
    } else if (e.getKeyCode()==KeyEvent.VK_RIGHT ||
        e.getKeyCode()==KeyEvent.VK_DOWN ||
        e.getKeyCode()==KeyEvent.VK_PAGE_DOWN ||
        e.getKeyCode()==KeyEvent.VK_KP_DOWN ||
        e.getKeyCode()==KeyEvent.VK_KP_RIGHT) {
      curimg++;
      if (curimg>=imglist.length) curimg-=imglist.length;
			if(isRGB)
				imageData.loadRGBFileAsRGB(imglist[curimg]);
			else
				imageData.loadYUVFileAsRGB(imglist[curimg]);

      setTitle(imglist[curimg]);
      int[] data=imageData.getPixels();
      showImage(data, tmap, imageData.image_width, imageData.image_height);
    }
  }
  public void keyReleased(KeyEvent e) { }
  public void keyTyped(KeyEvent e) { }
}
