/** @file ImageData.java
 *  @brief 
 *
 *  File that contains the functions for the data
 *  contained in each image.
 *
 *	@author editted by: Eric Durback
 *  @bug No known bugs.
 */

import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;
import java.awt.image.Raster;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;


public class ImageData extends Frame {
  Toolkit toolkit;

  public int[][]retdata;
  public int[][] data;
  public int[] alldata;

  public float[][] RG;  //change all to [][]
  public float[][] HS;
  public float[][] HB;
  public float[][] SB;
  
  public float[] allHS;

  public int image_width;
  public int image_height;
  
  public int numImages;
  public int curImage;
  
  public ImageData()
  {
  	this(1);
  }
  
  public ImageData(int numI) 
  {
    toolkit=Toolkit.getDefaultToolkit();
    curImage = 0;
    numImages = numI;
    data = new int[numI][];
    retdata = new int[numI][];
    HS = new float[numI][];
    HB = new float[numI][];
    RG = new float[numI][];
    SB = new float[numI][];
    
  }

  public int[] getPixels() 
  {
  	return retdata[curImage];
  }
  
  public int[][] getAllPixels() {
    return retdata;
  }
  
   public int[] getSpecialPixels() {
    return alldata;
  }

	// assumes retdata holds RGB
  public float[] getRG() {
    if (RG[curImage]==null) {
      RG[curImage]=new float[retdata[curImage].length*2];
      for (int i=0; i<retdata[curImage].length; i++) {
        float r=(float)((retdata[curImage][i]>>16)&0xFF);
        float g=(float)((retdata[curImage][i]>>8)&0xFF);
        float b=(float)(retdata[curImage][i]&0xFF);
        RG[curImage][i*2]=r/(r+g+b);
        RG[curImage][i*2+1]=g/(r+g+b);
      }
    }
    return RG[curImage];
  }

	// assumes retdata holds RGB
  public float[] getHS() 
  {
    if (HS[curImage]==null) 
    {
      HS[curImage]=new float[retdata[curImage].length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata[curImage].length; i++) 
      {
        int r=(retdata[curImage][i]>>16)&0xFF;
        int g=(retdata[curImage][i]>>8)&0xFF;
        int b=retdata[curImage][i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        HS[curImage][i*2]=hsb[0];
        HS[curImage][i*2+1]=hsb[1];
      }
    }
    return HS[curImage];
  }
  
  public float[] getSpecialHS() 
  {
  	if (allHS==null) 
    {
      allHS=new float[alldata.length*2];
      float[] hsb=new float[3];
      for (int i=0; i<alldata.length; i++) 
      {
        int r=(alldata[i]>>16)&0xFF;
        int g=(alldata[i]>>8)&0xFF;
        int b=alldata[i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        allHS[i*2]=hsb[0];
        allHS[i*2+1]=hsb[1];
      }
    }
    return allHS;
  	
  }

  public float[][] getAllHS()
  {
    
    for(int k=0; k<numImages; k++)
    {
	    if (HS[k]==null && retdata[k] != null) 
	    {
	      HS[k]=new float[retdata[k].length*2];
	      float[] hsb=new float[3];
	      for (int i=0; i<retdata[k].length; i++) 
	      {
	        int r=(retdata[k][i]>>16)&0xFF;
	        int g=(retdata[k][i]>>8)&0xFF;
	        int b=retdata[k][i]&0xFF;
	        Color.RGBtoHSB(r, g, b, hsb);
	        HS[k][i*2]=hsb[0];
	        HS[k][i*2+1]=hsb[1];
	      }
	    }
    }
    return HS;
  }

	// assumes retdata holds RGB
  public float[] getHB() {
    if (HB[curImage]==null) {
      HB[curImage]=new float[retdata[curImage].length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata[curImage].length; i++) {
        int r=(retdata[curImage][i]>>16)&0xFF;
        int g=(retdata[curImage][i]>>8)&0xFF;
        int b=retdata[curImage][i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        HB[curImage][i*2]=hsb[0];
        HB[curImage][i*2+1]=hsb[2];
      }
    }
    return HB[curImage];
  }

	// assumes retdata holds RGB
  public float[] getSB() {
    if (SB[curImage]==null) {
      SB[curImage]=new float[retdata[curImage].length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata[curImage].length; i++) {
        int r=(retdata[curImage][i]>>16)&0xFF;
        int g=(retdata[curImage][i]>>8)&0xFF;
        int b=retdata[curImage][i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        SB[curImage][i*2]=hsb[1];
        SB[curImage][i*2+1]=hsb[2];
      }
    }
    return SB[curImage];
  }
  
 

  void loadFile(String filename) 
  {
    // System.out.println("Loading: " + filename);
    Image image=toolkit.createImage(filename);
    MediaTracker mediaTracker=new MediaTracker(this);
    mediaTracker.addImage(image, 0);
    try {
      mediaTracker.waitForID(0);
    } catch (InterruptedException e) {
      System.out.println(e);
      System.exit(1);
    }
    image_width=image.getWidth(this);
    image_height=image.getHeight(this);

    BufferedImage bi = new BufferedImage(image_width, image_height,
                                         BufferedImage.TYPE_INT_RGB);
    Graphics big = bi.createGraphics();
    big.drawImage(image,0,0,null);
    data[curImage]=bi.getRGB(0,0,image_width,image_height,null,0,image_width);
    
  }

	public void loadYUVJPEG(String filename) {
		try {
			ImageInputStream jpegStream=new MemoryCacheImageInputStream(new FileInputStream(filename));
			ImageReader jpegReader=(ImageReader)ImageIO.getImageReadersByFormatName("jpeg").next();
			jpegReader.setInput(jpegStream); 
			Raster decoded=jpegReader.readRaster(0,null);
			image_width=decoded.getWidth();
			image_height=decoded.getHeight();
			data[curImage] = new int[image_width*image_height];
			int off=0;
			for(int y=0; y<image_height; y++)
				for(int x=0; x<image_width; x++) {
					int yc=decoded.getSample(x,y,0);
					int uc=decoded.getSample(x,y,2);
					int vc=decoded.getSample(x,y,1);
					data[curImage][off++]=(yc<<16) | (uc<<8) | vc;
				}
		} catch(Exception ex) { ex.printStackTrace(); }
	}

  public void loadYUVFileAsRGB(String filename) {
    loadFile(filename);
    YUV2RGB();
    retdata[curImage]=data[curImage];
  }

	public void loadRGBFileAsYUV(String filename) {
		if(filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".JPG") || filename.endsWith(".JPEG"))
			loadYUVJPEG(filename);
		else {
			loadFile(filename);
			RGB2YUV();
		}
    retdata[curImage]=data[curImage];
	}

	public void loadRGBFileAsRGB(String filename) {
    loadFile(filename);
    retdata[curImage]=data[curImage];
	}

	public void loadYUVFileAsYUV(String filename) {
    loadFile(filename);
    retdata[curImage]=data[curImage];
	}

	// this isn't the "real" conversion, but a quick approx.
	// it's the same that's used in tekkotsumon's VisionListener
  public void YUV2RGB() {
    for (int i=0; i<data[curImage].length; i++) {
      int y=(int)((data[curImage][i]>>16)&0xFF);
      int u=(int)((data[curImage][i]>>8)&0xFF);
      int v=(int)(data[curImage][i]&0xFF);
      u=u*2-255;
      v=v*2-255;
      int r=y+u;
      int b=y+v;
      u=u>>1;
      v=(v>>2)-(v>>4);
      int g=y-u-v;
      if (r<0) r=0; if (g<0) g=0; if (b<0) b=0;
      if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;

      data[curImage][i]= (r<<16) | (g<<8) | b;
    }
  }

	// this isn't the "real" conversion, nor a quick approx, but
	// it will get as close as possible to an exact undo of the YUV2RGB conversion
	// we use in VisionListener (and here)
  public void RGB2YUV() {
    for (int i=0; i<data[curImage].length; i++) {
      int r=(int)((data[curImage][i]>>16)&0xFF);
      int g=(int)((data[curImage][i]>>8)&0xFF);
      int b=(int)(data[curImage][i]&0xFF);
			int y=(int)( 8*r/27 +  g/ 9  + 16*b/27 - 203/27);
			int u=(int)(19*r/54 -  g/18  -  8*b/27 +3544/27);
			int v=(int)(-4*r/27 +4*g/ 9  -  8*b/27 +3544/27); 
      if (y<0) y=0; if (u<0) u=0; if (v<0) v=0;
      if (y>255) y=255; if (u>255) u=255; if (v>255) v=255;
      data[curImage][i]= (y<<16) | (u<<8) | v;
    }
  }

  public void loadFullRGBFilesAsRGB(String files[]) 
  {
    for (int i=0; i<files.length; i++) 
    {
	  
	  loadFile(files[i]);
      
      if (i==0) alldata=new int[files.length*data[curImage].length];
			//for (int j=0; j<data.length; j++)
			//retdata[j+(i*data.length)]=data[j];
      int l=0;
	  for (int j=i; j<retdata[curImage].length; j+=files.length)
	  {
	  	alldata[j]=data[curImage][l++];
	  }
    }
  }

  public void loadFullYUVFilesAsRGB(String files[]) 
  {
    for (int i=0; i<files.length; i++) 
    {
      loadFile(files[i]);
      if (i==0) alldata=new int[files.length*data[curImage].length];
      YUV2RGB();
      int l=0;
      for (int j=i; j<alldata.length; j+=files.length)
        alldata[j]=data[curImage][l++];
    }
  }
  
  public void setCurimg(int curimg)
  {
  	curImage = curimg; 
  
  }
  
}
