/** @file ColorControlPanel.java
 *  @brief Frame for the Control panel allowing you to switch
 *		   colors and do actions of the selected colors.
 *
 *	@author editted by: Eric Durback
 *  @bug No known bugs.
 */

import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;
import javax.swing.JScrollPane;
import java.util.prefs.Preferences;

public class ColorControlPanel extends JFrame implements ActionListener,
    ListSelectionListener, ComponentListener 
{
	Container root;
	JTextField colorname;
	JList colorlist;
	DefaultListModel list;
	JScrollPane colorlistscroll;
	JButton remove, clear, save, autoSelect, load, undo, help;
	JCheckBox showColors,invert;
	JFileChooser chooser;

	String defaultName;

	int curcolor;
	int numDefault;

	TrainCanvas trainCanvas;
	ImageShowArea imageShow;

	static Preferences prefs = Preferences.userNodeForPackage(ColorControlPanel.class);


	public ColorControlPanel (TrainCanvas trainCanvas, ImageShowArea imageShow) 
	{
		this.trainCanvas=trainCanvas;
		this.imageShow=imageShow;
		imageShow.addMouseMotionListener(trainCanvas);
		imageShow.addMouseListener(trainCanvas);
		

		numDefault = 1;
		setSize(new Dimension (120,460));
		setTitle("Control Panel");
		setLocation(prefs.getInt("ColorControlPanel.location.x",50),prefs.getInt("ColorControlPanel.location.y",50));


		setResizable(false);
		root=this.getContentPane();
		root.setLayout(new FlowLayout());

		colorname=new JTextField(10);
		colorname.addActionListener(this);
		root.add(colorname);

		list=new DefaultListModel();
		colorlist=new JList(list);
		colorlist.setFixedCellWidth(90);
		colorlist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		colorlist.addListSelectionListener(this);

		colorlistscroll=new JScrollPane(colorlist,
		                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		                    JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		root.add(colorlistscroll);
		
		addComponentListener(this);
		
		chooser = new JFileChooser();
		chooser.setSelectedFile(new File("default"));
		
		//Adding Buttons

		undo=new JButton("undo");
		undo.addActionListener(this);
		undo.setEnabled(false);
		root.add(undo);

		remove=new JButton("remove");
		remove.addActionListener(this);
		root.add(remove);

		clear=new JButton("clear");
		clear.addActionListener(this);
		root.add(clear);

		invert=new JCheckBox("invert");
		invert.addActionListener(this);
		root.add(invert);

		showColors=new JCheckBox("all colors");
		showColors.addActionListener(this);
		root.add(showColors);

		autoSelect=new JButton("auto select");
		autoSelect.addActionListener(this);
		//root.add(autoSelect);

		help=new JButton("help");
		help.addActionListener(this);
		root.add(help);


		save=new JButton("save");
		save.addActionListener(this);
		root.add(save);

		load =new JButton("load");
		load.addActionListener(this);
		root.add(load);

		setCurColor(-1);
		setVisible(true);

		
	}


	    
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource()==save) 
		{
			
			
			int returnval=chooser.showSaveDialog(save);
			if (returnval==JFileChooser.APPROVE_OPTION) 
			{
				try{
					trainCanvas.save(chooser.getSelectedFile().getAbsolutePath());
				    chooser.setSelectedFile(chooser.getSelectedFile());
				    
				}catch(Exception e2){}
			}
		}

		if (e.getSource()==load) 
		{
			
			int returnval=chooser.showOpenDialog(load);
			if (returnval==JFileChooser.APPROVE_OPTION) 
			{
				
				try{
				    if(preLoad(chooser.getSelectedFile().getAbsolutePath()))
				    {	        	
				    	trainCanvas.load(chooser.getSelectedFile().getAbsolutePath());   
				    	chooser.setSelectedFile(chooser.getSelectedFile());
				    
				    }
				}
				catch(Exception w){}

			}
			
			setCurColor(0);
		}
		 
		else if (e.getSource()==clear) 
		{
			trainCanvas.clear();
		} 
		else if (e.getSource()==invert) 
		{
			trainCanvas.invert();
		} 
		else if (e.getSource()==showColors) 
		{
			trainCanvas.showColors();
		}
		else if (e.getSource()==autoSelect) 
		{
		 	trainCanvas.autoSelect();
		} 
		else if (e.getSource()==undo) 
		{
		  	trainCanvas.undo();
		} 
		else if (e.getSource()==help) 
		{
		 	trainCanvas.help();
		} 
		else if (e.getSource()==remove) 
		{
		  	trainCanvas.remove((String)list.get(curcolor));
		  	list.remove(curcolor);
		  	setCurColor(-1);
		  /*} else if (e.getSource()==imageview) {
		imageShow.show();*/
		} 
		else if (e.getSource()==colorname) 
		{
			String s=e.getActionCommand();
			if (!s.equals("")) 
			{
				int i;
				for (i=0; i<list.getSize() && !list.get(i).equals(s); i++) {}
				
				if (i==list.getSize()) 
				{
				  list.addElement(s);
				  colorname.setText("");
				  colorlist.setSelectedIndex(i);
				}
			}
		}
	}

	public void addDefaultColor()
	{
		String s="default" + numDefault++;
		if (!s.equals("")) 
		{
			int i=0;
		    while (i<list.getSize() && !list.get(i).equals(s)) 
		    {
		      	i++;
		    }
		    if (i==list.getSize()) 
		    {
		      	list.addElement(s);
		      	colorname.setText("");
		      	colorlist.setSelectedIndex(i);
		    }

		}
	}

	public void valueChanged(ListSelectionEvent e) 
	{

		if (!e.getValueIsAdjusting()) 
		{
			setCurColor(colorlist.getSelectedIndex());
		}

		if(colorlist.getSelectedIndex() < 0)
		{
			trainCanvas.setCurColor(null);
			imageShow.setCurArea(null);
			trainCanvas.plotImage();
		}

	}
	//sets up the control panel for the new saved environment
	public boolean preLoad(String filename) throws FileNotFoundException, IOException
	{
		int dotpos=filename.lastIndexOf('.');
		if (dotpos>0) filename=filename.substring(0,dotpos);

		BufferedReader areaFile=new BufferedReader(new FileReader(filename + ".save"));

		areaFile.readLine();

		int numColors = Integer.parseInt(areaFile.readLine());

		//Clearing current color list
		
		int sizeL = list.getSize();

		
		for(int i=0; i<sizeL; i++ )
		{
		 
		  	trainCanvas.remove((String)list.get(0));
		  	list.remove(0);	
		}

		for(int j=0; j<numColors; j++)
		{
			String s = areaFile.readLine();
			if (!s.equals("")) 
		    {
			    
			    list.addElement(s);
			    colorname.setText("");
			    colorlist.setSelectedIndex(j);
		  	}
		}

		//load all files into imageData
		for(int i=0; i<imageShow.imglist.length; i++)
		{
			imageShow.imageData.setCurimg(i);
			if(imageShow.isRGB)
		    {
				imageShow.imageData.loadRGBFileAsRGB(imageShow.imglist[i]);
			
		    }
		 	else
		    {
				imageShow.imageData.loadYUVFileAsRGB(imageShow.imglist[i]);
			
		    }
		}

		

		return true;

	}

	void setCurColor(int index) 
	{
		curcolor=index;

		if (index<0) 
		{
		  	remove.setEnabled(false);
		  	clear.setEnabled(false);
		  	trainCanvas.setCurColor(null);
		} 
		else 
		{
		  	remove.setEnabled(true);
		  	clear.setEnabled(true);
		  	trainCanvas.setCurColor((String)list.get(curcolor));
		}
	}
	
	public void componentResized(ComponentEvent e) {}
	public void componentHidden(ComponentEvent e) {}

	public void componentMoved(ComponentEvent e)
	{ 
	
		prefs.putInt("ColorControlPanel.location.x",getLocation().x);
		prefs.putInt("ColorControlPanel.location.y",getLocation().y);

	}
	public void componentShown(ComponentEvent e) {}

	public void enableUndo()
	{
		undo.setEnabled(true);
	}

	public void disableUndo()
	{
		undo.setEnabled(false);
	}

  
}
