#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/FlashIPAddrBehavior.h"
#include "Behaviors/Demos/SimpleChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"
#include "Behaviors/Demos/AutoGetupBehavior.h"
#include "Behaviors/Demos/BatteryMonitorBehavior.h"
#include "Behaviors/Demos/HeadLevelBehavior.h"
#include "Behaviors/Demos/ToggleHeadLightBehavior.h"
#include "Behaviors/Demos/CrashTestBehavior.h"
#include "Behaviors/Demos/FreezeTestBehavior.h"
#include "Behaviors/Demos/RelaxBehavior.h"
#include "Behaviors/Demos/WorldStateVelDaemon.h"
#include "Behaviors/Demos/CameraBehavior.h"
#include "Behaviors/Demos/MotionStressTestBehavior.h"
#include "Behaviors/Demos/ASCIIVisionBehavior.h"
#include "Behaviors/Nodes/TailWagNode.h"

#include "Shared/WorldState.h"
#include "Shared/ERS210Info.h"

ControlBase*
StartupBehavior::SetupBackgroundBehaviors() {
	addItem(new ControlBase("Background Behaviors","Background daemons and monitors"));
	startSubMenu();
	{ 
		addItem((new BehaviorSwitchControl<FlashIPAddrBehavior>("Flash IP Address",false))->start());
		addItem(new BehaviorSwitchControl<SimpleChaseBallBehavior>("Simple Chase Ball",false));
		addItem(new BehaviorSwitchControl<StareAtBallBehavior>("Stare at Ball",false));
		addItem(new BehaviorSwitchControl<HeadLevelBehavior>("Head Level",false));
		if(state->robotDesign & WorldState::ERS220Mask)
			addItem(new BehaviorSwitchControl<ToggleHeadLightBehavior>("Toggle Head Light",false));
		addItem(new BehaviorSwitchControl<TailWagNode>("Wag Tail",false));
		addItem(new BehaviorSwitchControl<RelaxBehavior>("Relax",false));
		addItem(new BehaviorSwitchControl<CameraBehavior>("Camera",false));
		addItem((new BehaviorSwitchControl<ASCIIVisionBehavior>("ASCIIVision",false)));
		addItem(new ControlBase("Debugging Tests","Stress tests"));
		startSubMenu();
		{
			addItem(new BehaviorSwitchControl<MotionStressTestBehavior>("Motion Stress Test",false));
			addItem(new BehaviorSwitchControl<CrashTestBehavior>("Crash Test",false));
			addItem(new BehaviorSwitchControl<FreezeTestBehavior>("Freeze Test",false));
		}
		endSubMenu();
		addItem(new ControlBase("System Daemons","Provide some common sensor or event processing"));
		startSubMenu();
		{
			addItem((new BehaviorSwitchControl<AutoGetupBehavior>("Auto Getup",false)));
			addItem((new BehaviorSwitchControl<WorldStateVelDaemon>("World State Vel Daemon",false))->start());
			addItem((new BehaviorSwitchControl<BatteryMonitorBehavior>("Battery Monitor",false))->start());
		}
		endSubMenu();
	}
	return endSubMenu();
}
