//-*-c++-*-
#ifndef INCLUDED_SoundPlay_h_
#define INCLUDED_SoundPlay_h_

#include "Process.h"
#include "sim.h"
#include "IPC/ProcessID.h"
#include "IPC/SharedObject.h"
#include "SharedGlobals.h"
#include "Sound/SoundManager.h"

class SoundPlay : public Process {
public:
	//! constructor
	SoundPlay();
	//! destructor
	~SoundPlay();

	virtual void DoStart();
	virtual void DoStop();

	static const char * getClassName() { return "SoundPlay"; }
	static ProcessID::ProcessID_t getID() { return ProcessID::SoundProcess; }
	
	static const char * getSoundPlayID() { return "Sounds"; }
	static const char * getSoundManagerID() { return "SoundManager"; }

protected:
	SharedObject<sim::SoundPlayQueue_t> requests;
	SharedObject<sim::EventQueue_t> events;
	SharedObject<SoundManager> soundmanager;
	IPCEventTranslator * etrans;
	class MessageReceiver * sndrecv;
	static bool gotSnd(RCRegion* msg) { sndman->ProcessMsg(msg); return true; }
	
private:
	SoundPlay(const SoundPlay&); //!< don't call (copy constructor)
	SoundPlay& operator=(const SoundPlay&); //!< don't call (assignment operator)
};

/*! @file
 * @brief Defines SoundPlay, which DESCRIPTION
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2005/06/29 22:06:41 $
 */

#endif
