#include "SharedGlobals.h"

const char * const SharedGlobals::runlevel_names[SharedGlobals::NUM_RUNLEVELS] = {
	"CREATED",
	"CONSTRUCTING",
	"STARTING",
	"RUNNING",
	"STOPPING",
	"DESTRUCTING",
	"DESTRUCTED"
};

ipc_setup_t * ipc_setup=NULL;
SharedGlobals * globals=NULL;

unsigned int SharedGlobals::get_time() {
	if(timeScale<=0) {
		//just need to update lastTimeScale in case it had been realtime mode
		//adding an 'if' to test before the assignment is slower than just always doing the assignment
		lastTimeScale=timeScale;
	} else {
		if(lastTimeScale<=0) {
			//switching from non-realtime to realtime mode -- reset time offset
			timeOffset=bootTime.Age().Value()*timeScale*1000-simulatorTime;
			lastTimeScale=timeScale;
			//we reset timeOffset such that simulatorTime hasn't changed
		} else if(lastTimeScale!=timeScale) {
			//switching speeds -- reset time offset
			simulatorTime=get_real_time(lastTimeScale);
			timeOffset=bootTime.Age().Value()*timeScale*1000-simulatorTime;
			lastTimeScale=timeScale;
		} else {
			simulatorTime=get_real_time(timeScale);
		}
		//cout << timeOffset << ' ' << lastTimeScale << ' ' << timeScale << endl;
	}
	return simulatorTime;
}

/*! @file
 * @brief A class to hold various simulator parameters which need to be accessed from multiple processes
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2005/07/27 17:37:53 $
 */
