//-*-c++-*-
#ifndef INCLUDED_Process_h_
#define INCLUDED_Process_h_

#include "IPC/ProcessID.h"
#include <string>

//! Represents a common interface for each process being run
class Process {
public:
	Process(ProcessID::ProcessID_t pid, const std::string& pname);
	virtual ~Process();
	virtual void DoStart() {}
	virtual void DoStop() {}
	virtual void run();

	static const std::string& getName() { return name; }
	static Process * getCurrent() { return current; }

protected:
	static std::string name;
	static Process * current;
	
private:
	Process(const Process&);            //!< don't call
	Process& operator=(const Process&); //!< don't call
};

/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/06/15 18:54:43 $
 */

#endif
