#include "Process.h"
#include "SharedGlobals.h"
#include <unistd.h>

std::string Process::name;
Process * Process::current;

Process::Process(ProcessID::ProcessID_t pid, const std::string& pname) {
	ProcessID::setID(pid);
	name=pname;
	current=this;
	globals->pids[ProcessID::getID()]=getpid();
	strncpy(globals->processNames[ProcessID::getID()],name.c_str(),SharedGlobals::MAX_PROCESS_NAME_LEN);
}

Process::~Process() {
	current=NULL;
}

void Process::run() {
	globals->waitShutdown();
}

/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/06/15 18:54:26 $
 */
