//-*-c++-*-
#ifndef INCLUDED_Motion_h_
#define INCLUDED_Motion_h_

#include "Process.h"
#include "sim.h"
#include "IPC/ProcessID.h"
#include "IPC/SharedObject.h"
#include "SharedGlobals.h"
#include "Motion/MotionManager.h"
#include "Sound/SoundManager.h"
#include "Shared/WorldState.h"

class Motion : public Process {
public:
	//! constructor
	Motion();
	//! destructor
	~Motion();

	virtual void DoStart();
	virtual void run();
	virtual void DoStop();

	static const char * getClassName() { return "Motion"; }
	static ProcessID::ProcessID_t getID() { return ProcessID::MotionProcess; }
	
	static const char * getMotionCommandID() { return "MotionCommands"; }
	static const char * getMotionManagerID() { return "MotionManager"; }

protected:
	SharedObject<sim::SoundPlayQueue_t> sounds;
	SharedObject<sim::MotionCommandQueue_t> motions;
	SharedObject<sim::EventQueue_t> events;
	SharedObject<MotionManager> motionmanager;
	SharedObject<SoundManager> soundmanager;
	SharedObject<WorldState> worldstate;
	IPCEventTranslator * etrans;
	class MessageReceiver * mcrecv;
	WirelessThread wireless_thread;

	static bool gotMC(RCRegion* msg) { motman->processMsg(msg); return true; }
	
private:
	Motion(const Motion&); //!< don't call (copy constructor)
	Motion& operator=(const Motion&); //!< don't call (assignment operator)
};

/*! @file
 * @brief Defines Motion, which DESCRIPTION
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2005/06/29 22:06:41 $
 */

#endif
